/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.tile;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import landmaster.plustic.api.CentrifugeRecipes;
import landmaster.plustic.config.Config;
import landmaster.plustic.net.PacketHandler;
import landmaster.plustic.net.PacketUpdateTECentrifugeCoreEnergy;
import landmaster.plustic.tile.TECentrifuge;
import landmaster.plustic.tile.TECentrifugeTank;
import landmaster.plustic.util.Coord4D;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;

public class TECentrifugeCore
extends TECentrifuge
implements ITickable {
    protected EnergyStorage energyStorage;
    protected int oldEnergy;
    public static final int ENERGY_BUFFER_SZ = 80000;
    private AlloyRecipe cachedRecipe;

    public TECentrifugeCore() {
        this.setEnergy(0);
        this.tank.setCanDrain(false);
        this.cachedRecipe = null;
    }

    public List<TECentrifugeTank> getOutputTanks() {
        ArrayList<TECentrifugeTank> result = new ArrayList<TECentrifugeTank>();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p());
        while (this.field_145850_b.func_175625_s((BlockPos)checkPos) instanceof TECentrifugeTank) {
            result.add((TECentrifugeTank)this.field_145850_b.func_175625_s((BlockPos)checkPos));
            checkPos.func_189536_c(EnumFacing.UP);
        }
        return result;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.oldEnergy != this.energyStorage.getEnergyStored()) {
            this.func_70296_d();
            this.oldEnergy = this.energyStorage.getEnergyStored();
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketUpdateTECentrifugeCoreEnergy(new Coord4D(this.field_174879_c, this.field_145850_b), this.energyStorage.getEnergyStored()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
        }
        if (this.tank.getFluid() == null || this.tank.getFluid().amount <= 0) {
            return;
        }
        if (this.cachedRecipe == null || CentrifugeRecipes.matches(this.cachedRecipe, this.tank.getFluid()) <= 0) {
            this.cachedRecipe = TinkerRegistry.getAlloys().stream().filter(recipe -> CentrifugeRecipes.matches(recipe, this.tank.getFluid()) > 0).sorted(Comparator.comparingInt(recipe -> recipe.getFluids().size()).thenComparingInt(recipe -> recipe.getResult().amount)).findFirst().orElse(null);
        }
        if (this.cachedRecipe == null) {
            return;
        }
        List<TECentrifugeTank> tanks = this.getOutputTanks();
        if (tanks.size() < this.cachedRecipe.getFluids().size()) {
            return;
        }
        int numTimesToApply = Math.min(CentrifugeRecipes.matches(this.cachedRecipe, this.tank.getFluid()), CentrifugeRecipes.APPLY_PER_TICK);
        int energyToExtract = Config.centrifugeEnergyPerMB * this.cachedRecipe.getResult().amount;
        block0: for (int i = 0; i < numTimesToApply && this.energyStorage.extractEnergy(energyToExtract, true) >= energyToExtract; ++i) {
            int j;
            for (j = 0; j < this.cachedRecipe.getFluids().size(); ++j) {
                if (tanks.get((int)j).tank.fillInternal((FluidStack)this.cachedRecipe.getFluids().get(j), false) < ((FluidStack)this.cachedRecipe.getFluids().get((int)j)).amount) break block0;
            }
            this.tank.drainInternal(this.cachedRecipe.getResult(), true);
            this.energyStorage.extractEnergy(energyToExtract, false);
            for (j = 0; j < this.cachedRecipe.getFluids().size(); ++j) {
                tanks.get((int)j).tank.fillInternal((FluidStack)this.cachedRecipe.getFluids().get(j), true);
            }
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY ? this.energyStorage : super.getCapability(capability, facing));
    }

    public void setEnergy(int val) {
        this.energyStorage = new EnergyStorage(80000, 80000, 80000, val);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.setEnergy(compound.func_74762_e("Energy"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        return compound;
    }
}

