/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.darknesslib.api;

import com.shinoow.darknesslib.api.cap.DynamicLightsCapabilityProvider;
import com.shinoow.darknesslib.api.cap.IDynamicLightsCapability;
import com.shinoow.darknesslib.api.internal.DummyMethodHandler;
import com.shinoow.darknesslib.api.internal.IInternalMethodHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DarknessLibAPI {
    public static final String API_VERSION = "1.1.0";
    private static final DarknessLibAPI INSTANCE = new DarknessLibAPI();
    private final Map<ItemStack, Integer> DYNAMIC_LIGHTS_MAP = new HashMap<ItemStack, Integer>();
    private final List<Class<? extends Entity>> VEHICLES = new ArrayList<Class<? extends Entity>>();
    private final List<Function<EntityPlayer, Integer>> LIGHT_PROVIDERS = new ArrayList<Function<EntityPlayer, Integer>>();
    private IInternalMethodHandler internalMethodHandler = new DummyMethodHandler();
    private Logger LOGGER = LogManager.getLogger((String)"DarknessLibAPI");

    private DarknessLibAPI() {
    }

    public static DarknessLibAPI getInstance() {
        return INSTANCE;
    }

    public void addLightsource(ItemStack stack, int lightLevel) {
        if (stack.func_190926_b()) {
            return;
        }
        if (lightLevel > 0 && lightLevel < 16) {
            this.DYNAMIC_LIGHTS_MAP.put(stack, lightLevel);
            this.LOGGER.log(Level.INFO, "{} has been added to the Dynamic Lights List with Light level {}!", (Object)stack.func_77973_b().getRegistryName(), (Object)lightLevel);
        } else {
            this.LOGGER.log(Level.ERROR, "{} is an invalid light level", (Object)stack.func_77973_b().getRegistryName(), (Object)lightLevel);
        }
    }

    public void addVehicle(Class<? extends Entity> vehicle) {
        this.VEHICLES.add(vehicle);
    }

    public void addLightProvider(Function<EntityPlayer, Integer> provider) {
        this.LOGGER.log(Level.INFO, "{} added a Light Provider function!", (Object)Loader.instance().activeModContainer().getModId());
        this.LIGHT_PROVIDERS.add(provider);
    }

    public int getLight(Entity entityIn, boolean strict) {
        BlockPos blockpos = new BlockPos(entityIn.field_70165_t, entityIn.func_174813_aQ().field_72338_b, entityIn.field_70161_v);
        if (strict && !entityIn.field_70170_p.func_175665_u(blockpos) && !entityIn.field_70170_p.func_180495_p(blockpos).func_177230_c().func_176200_f((IBlockAccess)entityIn.field_70170_p, blockpos)) {
            blockpos = blockpos.func_177984_a();
        }
        return entityIn.field_70170_p.func_175671_l(blockpos);
    }

    public int getLightWithAdditions(EntityPlayer player, boolean strict) {
        return Math.max(this.getLight((Entity)player, strict), this.LIGHT_PROVIDERS.stream().mapToInt(l -> (Integer)l.apply(player)).max().orElse(0));
    }

    @Deprecated
    public int getLightWithDynLights(EntityPlayer player, boolean strict) {
        return this.getLightWithAdditions(player, strict);
    }

    public boolean hasDynamicLights(EntityPlayer player) {
        IDynamicLightsCapability cap = (IDynamicLightsCapability)player.getCapability(DynamicLightsCapabilityProvider.DYNAMIC_LIGHTS, null);
        return this.internalMethodHandler.isDynLightsModeEnabled() && cap.hasDynamicLights();
    }

    public int getLight(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Optional<Integer> val = this.DYNAMIC_LIGHTS_MAP.entrySet().stream().filter(e -> this.stacksEqual(stack, (ItemStack)e.getKey())).map(e -> (Integer)e.getValue()).findFirst();
        return val.orElse(0);
    }

    private boolean stacksEqual(ItemStack stack, ItemStack stack1) {
        return stack1.func_77973_b() == stack.func_77973_b() && (stack1.func_77952_i() == Short.MAX_VALUE || stack1.func_77952_i() == stack.func_77952_i());
    }

    public boolean isIlluminatedDynamically(EntityPlayer player) {
        if (this.hasDynamicLights(player)) {
            return this.getLight(player.func_184586_b(EnumHand.MAIN_HAND)) > 0 || this.getLight(player.func_184586_b(EnumHand.OFF_HAND)) > 0;
        }
        return false;
    }

    public boolean isVehicle(Entity entity) {
        return this.VEHICLES.stream().anyMatch(c -> c.isInstance(entity));
    }

    public void setInternalMethodHandler(IInternalMethodHandler handler) {
        if (this.internalMethodHandler.getClass().getName().equals(DummyMethodHandler.class.getName()) && Loader.instance().getLoaderState() == LoaderState.PREINITIALIZATION && Loader.instance().activeModContainer().getModId().equals("darknesslib")) {
            this.internalMethodHandler = handler;
        }
    }
}

