/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.gui;

import com.github.alexthe666.iceandfire.ClientProxy;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.gui.MyrmexDeleteButton;
import com.github.alexthe666.iceandfire.client.gui.bestiary.ChangePageButton;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageGetMyrmexHive;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiMyrmexStaff
extends GuiScreen {
    private static final ResourceLocation JUNGLE_TEXTURE = new ResourceLocation("iceandfire:textures/gui/myrmex_staff_jungle.png");
    private static final ResourceLocation DESERT_TEXTURE = new ResourceLocation("iceandfire:textures/gui/myrmex_staff_desert.png");
    private static final WorldGenMyrmexHive.RoomType[] ROOMS = new WorldGenMyrmexHive.RoomType[]{WorldGenMyrmexHive.RoomType.FOOD, WorldGenMyrmexHive.RoomType.NURSERY, WorldGenMyrmexHive.RoomType.EMPTY};
    private static final int ROOMS_PER_PAGE = 5;
    private final List<Room> allRoomPos = Lists.newArrayList();
    private final List<MyrmexDeleteButton> allRoomButtonPos = Lists.newArrayList();
    public ChangePageButton previousPage;
    public ChangePageButton nextPage;
    int ticksSinceDeleted = 0;
    int currentPage = 0;
    private ItemStack staff;
    private boolean jungle;
    private int hiveCount;

    public GuiMyrmexStaff(ItemStack staff) {
        this.staff = staff;
        this.jungle = staff.func_77973_b() == IafItemRegistry.myrmex_jungle_staff;
        this.func_73866_w_();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.allRoomButtonPos.clear();
        int i = (this.field_146294_l - 248) / 2;
        int j = (this.field_146295_m - 166) / 2;
        int x_translate = 193;
        int y_translate = 37;
        if (ClientProxy.getReferedClientHive() == null) {
            return;
        }
        this.populateRoomMap();
        this.field_146292_n.add(new GuiButton(0, i + 124, j + 15, 120, 20, ClientProxy.getReferedClientHive().reproduces ? I18n.func_135052_a((String)"myrmex.message.disablebreeding", (Object[])new Object[0]) : I18n.func_135052_a((String)"myrmex.message.enablebreeding", (Object[])new Object[0])));
        this.previousPage = new ChangePageButton(1, i + 5, j + 150, false, 0, this.jungle ? 2 : 1);
        this.field_146292_n.add(this.previousPage);
        this.nextPage = new ChangePageButton(2, i + 225, j + 150, true, 0, this.jungle ? 2 : 1);
        this.field_146292_n.add(this.nextPage);
        int totalRooms = this.allRoomPos.size();
        for (int rooms = 0; rooms < this.allRoomPos.size(); ++rooms) {
            int yIndex = rooms % 5;
            MyrmexDeleteButton button = new MyrmexDeleteButton(2 + rooms, i + x_translate, j + y_translate + yIndex * 22, this.allRoomPos.get((int)rooms).pos, I18n.func_135052_a((String)"myrmex.message.delete", (Object[])new Object[0]));
            button.field_146125_m = rooms < 5 * (this.currentPage + 1) && rooms >= 5 * this.currentPage;
            this.field_146292_n.add(button);
            this.allRoomButtonPos.add(button);
        }
        if (totalRooms <= 5 * this.currentPage && this.currentPage > 0) {
            --this.currentPage;
        }
    }

    private void populateRoomMap() {
        this.allRoomPos.clear();
        for (WorldGenMyrmexHive.RoomType type : ROOMS) {
            List<BlockPos> roomPos = ClientProxy.getReferedClientHive().getRooms(type);
            for (BlockPos pos : roomPos) {
                String name = type == WorldGenMyrmexHive.RoomType.FOOD ? "food" : (type == WorldGenMyrmexHive.RoomType.NURSERY ? "nursery" : "misc");
                this.allRoomPos.add(new Room(pos, name));
            }
        }
        for (BlockPos pos : ClientProxy.getReferedClientHive().getEntrances().keySet()) {
            this.allRoomPos.add(new Room(pos, "enterance_surface"));
        }
        for (BlockPos pos : ClientProxy.getReferedClientHive().getEntranceBottoms().keySet()) {
            this.allRoomPos.add(new Room(pos, "enterance_bottom"));
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            ClientProxy.getReferedClientHive().reproduces = !ClientProxy.getReferedClientHive().reproduces;
        } else if (button.field_146127_k == 1 && this.currentPage > 0) {
            --this.currentPage;
        }
        if (button.field_146127_k == 2 && this.currentPage < this.allRoomButtonPos.size() / 5) {
            ++this.currentPage;
        } else if (button instanceof MyrmexDeleteButton && this.ticksSinceDeleted <= 0) {
            ClientProxy.getReferedClientHive().removeRoom(((MyrmexDeleteButton)button).pos);
            this.ticksSinceDeleted = 5;
        }
        this.func_73866_w_();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146276_q_() {
        super.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.jungle ? JUNGLE_TEXTURE : DESERT_TEXTURE);
        int i = (this.field_146294_l - 248) / 2;
        int j = (this.field_146295_m - 166) / 2;
        this.func_73729_b(i, j, 0, 0, 248, 166);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        if (this.ticksSinceDeleted > 0) {
            --this.ticksSinceDeleted;
        }
        this.func_73866_w_();
        int i = (this.field_146294_l - 248) / 2 + 10;
        int j = (this.field_146295_m - 166) / 2 + 8;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int color = this.jungle ? 3533333 : 0xFFBF00;
        this.hiveCount = 0;
        for (int rooms = 0; rooms < this.allRoomButtonPos.size(); ++rooms) {
            if (rooms >= 5 * (this.currentPage + 1) || rooms < 5 * this.currentPage) continue;
            this.drawRoomInfo(this.allRoomPos.get((int)rooms).string, this.allRoomPos.get((int)rooms).pos, i, j, color);
        }
        if (ClientProxy.getReferedClientHive() != null) {
            if (!ClientProxy.getReferedClientHive().colonyName.isEmpty()) {
                String title = I18n.func_135052_a((String)"myrmex.message.colony_named", (Object[])new Object[]{ClientProxy.getReferedClientHive().colonyName});
                this.field_146289_q.func_175065_a(title, (float)(i + 40 - title.length() / 2), (float)(j - 3), color, true);
            } else {
                this.field_146289_q.func_175065_a(I18n.func_135052_a((String)"myrmex.message.colony", (Object[])new Object[0]), (float)(i + 80), (float)(j - 3), color, true);
            }
            int opinion = ClientProxy.getReferedClientHive().getPlayerReputation(Minecraft.func_71410_x().field_71439_g.func_110124_au());
            this.field_146289_q.func_175065_a(I18n.func_135052_a((String)"myrmex.message.hive_opinion", (Object[])new Object[]{opinion}), (float)i, (float)(j + 12), color, true);
            this.field_146289_q.func_175065_a(I18n.func_135052_a((String)"myrmex.message.rooms", (Object[])new Object[0]), (float)i, (float)(j + 25), color, true);
        }
    }

    public void func_146281_b() {
        IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageGetMyrmexHive(ClientProxy.getReferedClientHive()));
    }

    private void drawRoomInfo(String type, BlockPos pos, int i, int j, int color) {
        String translate = "myrmex.message.room." + type;
        this.field_146289_q.func_175065_a(I18n.func_135052_a((String)translate, (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}), (float)i, (float)(j + 36 + this.hiveCount * 22), color, true);
        ++this.hiveCount;
    }

    private class Room {
        public BlockPos pos;
        public String string;

        public Room(BlockPos pos, String string) {
            this.pos = pos;
            this.string = string;
        }
    }
}

