/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.model.util.IceAndFireTabulaModel;
import com.github.alexthe666.iceandfire.entity.EntityDragonSkull;
import com.github.alexthe666.iceandfire.enums.EnumDragonTextures;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderDragonSkull
extends Render<EntityDragonSkull> {
    public static final float[] growth_stage_1 = new float[]{1.0f, 3.0f};
    public static final float[] growth_stage_2 = new float[]{3.0f, 7.0f};
    public static final float[] growth_stage_3 = new float[]{7.0f, 12.5f};
    public static final float[] growth_stage_4 = new float[]{12.5f, 20.0f};
    public static final float[] growth_stage_5 = new float[]{20.0f, 30.0f};
    public float[][] growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};
    private IceAndFireTabulaModel fireDragonModel;
    private IceAndFireTabulaModel iceDragonModel;

    public RenderDragonSkull(RenderManager renderManager, ModelBase fireDragonModel, ModelBase iceDragonModel) {
        super(renderManager);
        this.fireDragonModel = (IceAndFireTabulaModel)fireDragonModel;
        this.iceDragonModel = (IceAndFireTabulaModel)iceDragonModel;
    }

    private static void setRotationAngles(ModelRenderer cube, float rotX, float rotY, float rotZ) {
        cube.field_78795_f = rotX;
        cube.field_78796_g = rotY;
        cube.field_78808_h = rotZ;
    }

    public void doRender(EntityDragonSkull entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179114_b((float)entity.getYaw(), (float)0.0f, (float)-1.0f, (float)0.0f);
        float f = 0.0625f;
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        this.func_180548_c((Entity)entity);
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        float size = this.getRenderSize(entity) / 3.0f;
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
        GlStateManager.func_179109_b((float)0.0f, (float)(entity.isOnWall() ? -0.24f : -0.12f), (float)0.5f);
        if (entity.getType() == 0) {
            this.fireDragonModel.resetToDefaultPose();
            RenderDragonSkull.setRotationAngles((ModelRenderer)this.fireDragonModel.getCube("Head"), entity.isOnWall() ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
            this.fireDragonModel.getCube("Head").func_78785_a(0.0625f);
        }
        if (entity.getType() == 1) {
            this.iceDragonModel.resetToDefaultPose();
            RenderDragonSkull.setRotationAngles((ModelRenderer)this.iceDragonModel.getCube("Head"), entity.isOnWall() ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
            this.iceDragonModel.getCube("Head").func_78785_a(0.0625f);
        }
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntityDragonSkull entity) {
        if (entity.getType() == 1) {
            return EnumDragonTextures.getIceDragonSkullTextures(entity);
        }
        return EnumDragonTextures.getFireDragonSkullTextures(entity);
    }

    public float getRenderSize(EntityDragonSkull skull) {
        float step = (this.growth_stages[skull.getDragonStage() - 1][1] - this.growth_stages[skull.getDragonStage() - 1][0]) / 25.0f;
        if (skull.getDragonAge() > 125) {
            return this.growth_stages[skull.getDragonStage() - 1][0] + step * 25.0f;
        }
        return this.growth_stages[skull.getDragonStage() - 1][0] + step * (float)this.getAgeFactor(skull);
    }

    private int getAgeFactor(EntityDragonSkull skull) {
        return skull.getDragonStage() > 1 ? skull.getDragonAge() - 25 * (skull.getDragonStage() - 1) : skull.getDragonAge();
    }
}

