/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.compat.waila;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.config.FormattingConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class HUDHandlerMultipartMob
implements IWailaEntityProvider {
    public static int nhearts = 20;
    public static float maxhpfortext = 40.0f;
    public static IWailaEntityProvider INSTANCE = new HUDHandlerMultipartMob();

    @Nonnull
    public List<String> getWailaHead(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        currenttip.clear();
        EntityMutlipartPart part = (EntityMutlipartPart)entity;
        if (!Strings.isNullOrEmpty((String)FormattingConfig.entityFormat)) {
            try {
                currenttip.add("\u00a7r" + String.format(FormattingConfig.entityFormat, part.getParent().func_70005_c_()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return currenttip;
    }

    @Nonnull
    public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        EntityMutlipartPart part = (EntityMutlipartPart)entity;
        if (config.getConfig("general.showhp") && part.getParent() instanceof EntityLivingBase) {
            nhearts = nhearts <= 0 ? 20 : nhearts;
            float health = part.getParent().func_110143_aJ() / 2.0f;
            float maxhp = part.getParent().func_110138_aP() / 2.0f;
            if (part.getParent().func_110138_aP() > maxhpfortext) {
                currenttip.add(String.format(I18n.func_74838_a((String)"hud.msg.health") + ": %.0f / %.0f", Float.valueOf(part.getParent().func_110143_aJ()), Float.valueOf(part.getParent().func_110138_aP())));
            } else {
                currenttip.add(SpecialChars.getRenderString((String)"waila.health", (String[])new String[]{String.valueOf(nhearts), String.valueOf(health), String.valueOf(maxhp)}));
            }
            if (part.getParent() instanceof EntityDragonBase) {
                EntityDragonBase dragon = (EntityDragonBase)part.getParent();
                currenttip.add(String.format(I18n.func_74838_a((String)"dragon.stage") + dragon.getDragonStage(), new Object[0]));
                if (dragon.isMale()) {
                    currenttip.add(String.format(I18n.func_74838_a((String)"dragon.gender.male"), new Object[0]));
                } else {
                    currenttip.add(String.format(I18n.func_74838_a((String)"dragon.gender.female"), new Object[0]));
                }
            }
        }
        return currenttip;
    }

    @Nonnull
    public List<String> getWailaTail(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        currenttip.clear();
        if (!Strings.isNullOrEmpty((String)FormattingConfig.modNameFormat)) {
            currenttip.add(String.format(FormattingConfig.modNameFormat, "Ice and Fire"));
        }
        return currenttip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity ent, NBTTagCompound tag, World world) {
        if (ent instanceof EntityMutlipartPart) {
            ent.func_189511_e(tag);
        }
        return tag;
    }
}

