/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.whocalled;

import me.nallar.whocalled.WhoCalled;

class WhoCalledProvider {
    private static final String[] whoCalledImplementations = new String[]{"WhoCalledReflection", "WhoCalledSecurityManager", "WhoCalledStackTrace"};
    private static final String[] brokenJavaVersion = new String[]{"1.7.0.25", null, null};

    WhoCalledProvider() {
    }

    static WhoCalled getWhoCalled() {
        assert (brokenJavaVersion.length == whoCalledImplementations.length);
        String javaVersion = System.getProperty("java.version").replace('_', '.');
        Throwable lastError = null;
        for (int i = 0; i < whoCalledImplementations.length; ++i) {
            String name = whoCalledImplementations[i];
            String brokenVersion = brokenJavaVersion[i];
            try {
                if (brokenVersion != null && WhoCalledProvider.versionCompare(javaVersion, brokenVersion) >= 0) continue;
                return WhoCalledProvider.tryWhoCalled(name);
            }
            catch (Throwable e) {
                lastError = e;
            }
        }
        throw new Error("Failed to set up any WhoCalled implementation", lastError);
    }

    private static WhoCalled tryWhoCalled(String name) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String className = WhoCalledProvider.class.getPackage().getName() + '.' + name;
        WhoCalled whoCalled = (WhoCalled)Class.forName(className).newInstance();
        Class<?> currentClass = whoCalled.getCallingClass(0);
        if (currentClass != WhoCalledProvider.class) {
            StringBuilder sb = new StringBuilder();
            sb.append("Stack:\n");
            for (int i = -2; i < 3; ++i) {
                try {
                    sb.append(whoCalled.getCallingClass(i).getName()).append(" at ").append(i).append('\n');
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw new Error("Wrong class returned: " + currentClass + ", expected WhoCalledProvider. " + sb);
        }
        return whoCalled;
    }

    private static int versionCompare(String firstString, String secondString) {
        int i;
        String[] first = firstString.split("\\.");
        String[] second = secondString.split("\\.");
        for (i = 0; i < first.length && i < second.length && first[i].equals(second[i]); ++i) {
        }
        if (i < first.length && i < second.length) {
            int diff = Integer.valueOf(first[i]).compareTo(Integer.valueOf(second[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(first.length - second.length);
    }
}

