/*
 * Decompiled with CFR 0.152.
 */
package levelup2.config;

import java.util.Random;
import levelup2.config.LevelUpConfig;
import levelup2.items.ItemOreChunk;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class OreChunkStorage {
    private final String oreName;
    private OreIngredient ore;
    private ItemStack smeltingItem;
    private final String smeltingResult;
    private final int color;
    private final int experienceYield;
    private final int metadata;
    private boolean active;
    private Item baseItem;
    private String placeholderItem;
    private int itemMeta;

    public OreChunkStorage(String oreName, String smelting, int color, int experience, int metadata) {
        this(oreName, smelting, color, experience, metadata, "");
    }

    public OreChunkStorage(String oreName, String smelting, int color, int experience, int metadata, String placeholderItem) {
        this.oreName = oreName;
        this.smeltingResult = smelting;
        this.color = color;
        this.experienceYield = experience;
        this.metadata = metadata;
        this.itemMeta = metadata;
        this.placeholderItem = placeholderItem;
    }

    public String getOreName() {
        return this.oreName;
    }

    public boolean oreMatches(ItemStack test) {
        return this.ore.apply(test);
    }

    public void setBaseItem(Item item) {
        if (!this.placeholderItem.equals("") && !LevelUpConfig.getStackFromString(this.placeholderItem).func_190926_b()) {
            ItemStack stack = LevelUpConfig.getStackFromString(this.placeholderItem);
            this.baseItem = stack.func_77973_b();
            this.itemMeta = stack.func_77960_j();
        } else {
            this.baseItem = item;
        }
    }

    public void registerOre() {
        if (this.baseItem instanceof ItemOreChunk) {
            OreDictionary.registerOre((String)this.oreName, (ItemStack)new ItemStack(this.baseItem, 1, this.itemMeta));
        }
    }

    public void registerOreIngredientLate() {
        this.ore = new OreIngredient(this.oreName);
        this.active = OreDictionary.getOres((String)this.oreName).size() > 1;
    }

    public ItemStack getSmeltingResult() {
        if (this.smeltingItem == null) {
            this.smeltingItem = LevelUpConfig.getStackFromString(this.smeltingResult);
            if (this.smeltingItem.func_190926_b()) {
                String type = this.getOreTypePlace() > 0 ? this.oreName.substring(this.getOreTypePlace()) : this.oreName;
                NonNullList ores = OreDictionary.getOres((String)("ingot" + type));
                if (!ores.isEmpty()) {
                    this.smeltingItem = (ItemStack)ores.get(0);
                } else {
                    ores = OreDictionary.getOres((String)("gem" + type));
                    if (!ores.isEmpty()) {
                        this.smeltingItem = (ItemStack)ores.get(0);
                    }
                }
            }
        }
        return this.smeltingItem.func_77946_l();
    }

    public int getColor() {
        return this.color;
    }

    public int getExperienceYield() {
        return this.experienceYield;
    }

    public boolean getActivation() {
        return this.active;
    }

    public Item getBaseItem() {
        return this.baseItem;
    }

    public int getMetadata() {
        return this.metadata;
    }

    public ItemStack getHarvestItem(Random rand, int fortune) {
        int count = 2;
        if (fortune > 0) {
            count += rand.nextInt(fortune + 1);
        }
        return new ItemStack(this.baseItem, count, this.itemMeta);
    }

    private int getOreTypePlace() {
        for (int i = 0; i < this.oreName.length(); ++i) {
            if (!Character.isUpperCase(this.oreName.charAt(i))) continue;
            return i;
        }
        return 0;
    }
}

