/*
 * Decompiled with CFR 0.152.
 */
package levelup2.event;

import levelup2.config.LevelUpConfig;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import levelup2.util.StealthLib;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CombatSkillHandler {
    public static final CombatSkillHandler INSTANCE = new CombatSkillHandler();
    private static final ResourceLocation ARROWSPEED = new ResourceLocation("levelup", "arrowspeed");
    private static final ResourceLocation ARROWDRAW = new ResourceLocation("levelup", "bowdraw");
    private static final ResourceLocation NATURALARMOR = new ResourceLocation("levelup", "naturalarmor");
    private static final ResourceLocation SHIELDBLOCK = new ResourceLocation("levelup", "shieldblock");
    private static final ResourceLocation STEALTHDAMAGE = new ResourceLocation("levelup", "stealthdamage");
    private static final ResourceLocation STEALTHSPEED = new ResourceLocation("levelup", "stealthspeed");
    private static final ResourceLocation SWORDCRIT = new ResourceLocation("levelup", "swordcrit");
    private static final ResourceLocation SWORDDAMAGE = new ResourceLocation("levelup", "sworddamage");
    private static final ResourceLocation COMBATBONUS = new ResourceLocation("levelup", "combat_bonus");
    private static final ResourceLocation FALLDAMAGE = new ResourceLocation("levelup", "fallprotect");
    private static final ResourceLocation SPRINTSPEED = new ResourceLocation("levelup", "sprintspeed");

    private CombatSkillHandler() {
    }

    @SubscribeEvent
    public void onArrowLoose(EntityJoinWorldEvent evt) {
        if (evt.getEntity() instanceof EntityArrow) {
            int archer;
            EntityArrow arrow = (EntityArrow)evt.getEntity();
            if (arrow.field_70250_c instanceof EntityPlayer && SkillRegistry.getPlayer((EntityPlayer)arrow.field_70250_c).isActive() && (archer = SkillRegistry.getSkillLevel((EntityPlayer)arrow.field_70250_c, ARROWSPEED)) > 0) {
                arrow.field_70159_w *= (double)(1.0f + (float)archer / 10.0f);
                arrow.field_70181_x *= (double)(1.0f + (float)archer / 10.0f);
                arrow.field_70179_y *= (double)(1.0f + (float)archer / 10.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBowUse(ArrowNockEvent evt) {
        int archery = SkillRegistry.getSkillLevel(evt.getEntityPlayer(), ARROWDRAW);
        if (archery > 0 && SkillRegistry.getPlayer(evt.getEntityPlayer()).isActive()) {
            evt.getEntityPlayer().func_184598_c(evt.getHand());
            this.setItemUseCount(evt.getEntityPlayer(), archery);
            evt.setAction(new ActionResult(EnumActionResult.SUCCESS, (Object)evt.getBow()));
        }
    }

    private void setItemUseCount(EntityPlayer player, int archery) {
        player.field_184628_bn -= archery;
    }

    @SubscribeEvent
    public void onDamageTaken(LivingHurtEvent evt) {
        if (evt.getEntityLiving() instanceof EntityPlayer && SkillRegistry.getPlayer((EntityPlayer)evt.getEntityLiving()).isActive()) {
            EntityPlayer player = (EntityPlayer)evt.getEntityLiving();
            int skill = SkillRegistry.getSkillLevel(player, NATURALARMOR);
            if (skill > 0 && !evt.getSource().func_76363_c()) {
                float amount = evt.getAmount() * (1.0f - (float)skill / 20.0f);
                evt.setAmount(amount);
            }
            if ((skill = SkillRegistry.getSkillLevel(player, SHIELDBLOCK)) > 0 && this.isBlocking(player) && player.func_70681_au().nextFloat() < (float)skill / 10.0f) {
                evt.setAmount(0.0f);
            }
            if ((skill = SkillRegistry.getSkillLevel(player, FALLDAMAGE)) > 0 && evt.getSource() == DamageSource.field_76379_h) {
                float reduction = Math.min((float)skill * 0.1f, 0.9f);
                evt.setAmount(evt.getAmount() * (1.0f - reduction));
                return;
            }
        }
        DamageSource src = evt.getSource();
        float dmg = evt.getAmount();
        if (src.func_76346_g() instanceof EntityPlayer && SkillRegistry.getPlayer((EntityPlayer)src.func_76346_g()).isActive()) {
            EntityPlayer player = (EntityPlayer)src.func_76346_g();
            int level = SkillRegistry.getSkillLevel(player, STEALTHDAMAGE);
            if (level > 0) {
                if (src instanceof EntityDamageSourceIndirect) {
                    if (StealthLib.getDistanceFrom(evt.getEntityLiving(), (EntityLivingBase)player) < 256.0f && player.func_70093_af() && !StealthLib.canSeePlayer(evt.getEntityLiving()) && !StealthLib.entityIsFacing(evt.getEntityLiving(), (EntityLivingBase)player)) {
                        dmg *= 1.0f + 0.15f * (float)level;
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("sneak.attack", new Object[]{1.0 + 0.15 * (double)level}), true);
                    }
                } else if (player.func_70093_af() && !StealthLib.canSeePlayer(evt.getEntityLiving()) && !StealthLib.entityIsFacing(evt.getEntityLiving(), (EntityLivingBase)player)) {
                    dmg *= 1.0f + 0.3f * (float)level;
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("sneak.attack", new Object[]{1.0 + 0.3 * (double)level}), true);
                }
            }
            if ((level = SkillRegistry.getSkillLevel(player, SWORDCRIT)) > 0 && !(src instanceof EntityDamageSourceIndirect) && !player.func_184614_ca().func_190926_b() && player.func_70681_au().nextDouble() <= (double)level / 20.0) {
                dmg *= 2.0f;
            }
            if ((level = SkillRegistry.getSkillLevel(player, SWORDDAMAGE)) > 0 && !(src instanceof EntityDamageSourceIndirect)) {
                if (!player.func_184614_ca().func_190926_b()) {
                    dmg *= 1.0f + (float)level / 20.0f;
                    if (LevelUpConfig.damageScaling && !(evt.getEntityLiving() instanceof EntityPlayer) && evt.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e() > 20.0) {
                        double health = evt.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
                        float skillOutput = (float)level / 40.0f;
                        dmg = (float)((double)dmg + Math.min(health * (double)skillOutput, health * 0.375));
                    }
                }
            } else if (SkillRegistry.getSkillLevel(player, ARROWSPEED) > 0 && src.func_76355_l().equals("arrow")) {
                level = SkillRegistry.getSkillLevel(player, ARROWSPEED);
                dmg *= 1.0f + (float)level / 20.0f;
                if (LevelUpConfig.damageScaling && !(evt.getEntityLiving() instanceof EntityPlayer) && evt.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e() > 20.0) {
                    double health = evt.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
                    float skillOutput = (float)level / 40.0f;
                    dmg = (float)((double)dmg + Math.min(health * (double)skillOutput, health * 0.375));
                }
            }
            if (dmg != evt.getAmount()) {
                evt.setAmount(dmg);
            }
        }
    }

    private boolean isBlocking(EntityPlayer player) {
        return player.func_184587_cr() && !player.func_184607_cu().func_190926_b() && player.func_184607_cu().func_77973_b().func_77661_b(player.func_184607_cu()) == EnumAction.BLOCK;
    }

    @SubscribeEvent
    public void onTargetSet(LivingSetAttackTargetEvent evt) {
        if (evt.getTarget() instanceof EntityPlayer && evt.getEntityLiving() instanceof EntityMob && evt.getTarget().func_70093_af() && !StealthLib.entityHasVisionOf(evt.getEntityLiving(), (EntityPlayer)evt.getTarget()) && evt.getEntityLiving().func_142015_aE() != ((EntityMob)evt.getEntityLiving()).field_70173_aa) {
            ((EntityMob)evt.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void onPlayerSneak(TickEvent.PlayerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START && SkillRegistry.getPlayer(evt.player).isActive()) {
            int skill = SkillRegistry.getSkillLevel(evt.player, STEALTHSPEED);
            if (skill > 0) {
                IAttributeInstance attrib = evt.player.func_110148_a(SharedMonsterAttributes.field_111263_d);
                AttributeModifier mod = new AttributeModifier(Library.sneakID, "SneakingSkillSpeed", (double)((float)skill / 10.0f), 2);
                if (evt.player.func_70093_af()) {
                    if (attrib.func_111127_a(Library.sneakID) == null) {
                        attrib.func_111121_a(mod);
                    }
                } else if (attrib.func_111127_a(Library.sneakID) != null) {
                    attrib.func_111124_b(mod);
                }
            } else if (SkillRegistry.getSkillLevel(evt.player, SPRINTSPEED) > 0) {
                IAttributeInstance attrib = evt.player.func_110148_a(SharedMonsterAttributes.field_111263_d);
                AttributeModifier mod = new AttributeModifier(Library.speedID, "SprintingSkillSpeed", (double)((float)SkillRegistry.getSkillLevel(evt.player, SPRINTSPEED) / 20.0f), 2);
                if (evt.player.func_70051_ag()) {
                    if (attrib.func_111127_a(Library.speedID) == null) {
                        attrib.func_111121_a(mod);
                    }
                } else if (attrib.func_111127_a(Library.speedID) != null) {
                    attrib.func_111124_b(mod);
                }
            }
        }
    }

    @SubscribeEvent
    public void getCombatBonus(LivingDeathEvent evt) {
        if (evt.getEntityLiving() instanceof EntityMob && evt.getSource().func_76346_g() instanceof EntityPlayer && SkillRegistry.getSkillLevel((EntityPlayer)evt.getSource().func_76346_g(), COMBATBONUS) > 0) {
            int deathXP = (int)evt.getEntityLiving().func_110138_aP();
            SkillRegistry.addExperience((EntityPlayer)evt.getSource().func_76346_g(), deathXP / 10);
        }
    }
}

