/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import levelup2.api.BaseClass;
import levelup2.api.BaseSkill;
import levelup2.api.ICharacterClass;
import levelup2.api.IPlayerSkill;
import levelup2.capability.PlayerCapability;
import levelup2.config.LevelUpConfig;
import levelup2.config.OreChunkStorage;
import levelup2.items.ItemExperienceBook;
import levelup2.items.ItemOreChunk;
import levelup2.items.ItemRespecBook;
import levelup2.network.SkillPacketHandler;
import levelup2.player.IPlayerClass;
import levelup2.util.ClassProperties;
import levelup2.util.Library;
import levelup2.util.PlankCache;
import levelup2.util.SkillProperties;
import levelup2.util.SmeltingBlacklist;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;

public class SkillRegistry {
    private static Map<String, Integer> oreBonusXP = Maps.newHashMap();
    private static Map<ResourceLocation, IPlayerSkill> skillHashMap = Maps.newHashMap();
    private static Map<ResourceLocation, ICharacterClass> classMap = Maps.newHashMap();
    private static Map<ResourceLocation, SkillProperties> skillProperties = Maps.newHashMap();
    private static Map<ResourceLocation, ClassProperties> classProperties = Maps.newHashMap();
    private static Map<ResourceLocation, List<IPlayerSkill>> specSkillCache = Maps.newHashMap();
    private static List<IPlantable> cropBlacklist = Lists.newArrayList();
    private static List<ResourceLocation> specializations = Lists.newArrayList();
    public static int smallestDisplayColumn = 0;
    public static int smallestDisplayRow = 0;
    public static int largestDisplayColumn = 0;
    public static int largestDisplayRow = 0;
    public static Item surfaceOreChunk = (Item)new ItemOreChunk(Library.SURFACE_ORES).func_77655_b("levelup:surfaceore").setRegistryName(new ResourceLocation("levelup2", "surfaceore"));
    public static Item netherOreChunk = (Item)new ItemOreChunk(Library.NETHER_ORES).func_77655_b("levelup:netherore").setRegistryName(new ResourceLocation("levelup2", "netherore"));
    public static Item endOreChunk = (Item)new ItemOreChunk(Library.END_ORES).func_77655_b("levelup:endore").setRegistryName(new ResourceLocation("levelup2", "endore"));
    public static Item respecBook = (Item)new ItemRespecBook().func_77655_b("levelup:respec").setRegistryName(new ResourceLocation("levelup2", "respecbook"));
    public static Item skillBook = (Item)new ItemExperienceBook().func_77655_b("levelup:skill").setRegistryName(new ResourceLocation("levelup2", "skillbook"));
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void loadSkills() {
        SkillRegistry.addCropsToBlacklist(LevelUpConfig.cropBlacklist);
        Library.registerLootManager();
        SkillRegistry.loadOreDict();
    }

    public static void postLoadSkills() {
    }

    private static void loadOreDict() {
        ArrayList names = Lists.newArrayList();
        for (OreChunkStorage stor : Library.ALL_ORES) {
            names.add(stor.getOreName());
        }
        if (names.contains("oreRedstone")) {
            Library.getOreList().add(Blocks.field_150439_ay);
        }
        Library.registerOres(names);
    }

    public static void registerRecipes() {
        if (!Library.SURFACE_ORES.isEmpty()) {
            for (OreChunkStorage stor : Library.SURFACE_ORES) {
                stor.setBaseItem(surfaceOreChunk);
                stor.registerOre();
            }
            Library.ALL_ORES.addAll(Library.SURFACE_ORES);
        }
        if (!Library.NETHER_ORES.isEmpty()) {
            for (OreChunkStorage stor : Library.NETHER_ORES) {
                stor.setBaseItem(netherOreChunk);
                stor.registerOre();
            }
            Library.ALL_ORES.addAll(Library.NETHER_ORES);
        }
        if (!Library.END_ORES.isEmpty()) {
            for (OreChunkStorage stor : Library.END_ORES) {
                stor.setBaseItem(endOreChunk);
                stor.registerOre();
            }
            Library.ALL_ORES.addAll(Library.END_ORES);
        }
        SkillRegistry.registerSmelting();
        for (OreChunkStorage stor : Library.ALL_ORES) {
            stor.registerOreIngredientLate();
        }
    }

    private static void registerSmelting() {
        for (OreChunkStorage stor : Library.ALL_ORES) {
            ItemStack result = stor.getSmeltingResult();
            if (result.func_190926_b()) continue;
            Item item = stor.getBaseItem();
            float exp = FurnaceRecipes.func_77602_a().func_151398_b(result);
            GameRegistry.addSmelting((ItemStack)new ItemStack(item, 1, stor.getMetadata()), (ItemStack)result, (float)exp);
        }
        SmeltingBlacklist.addItem(new ItemStack(Blocks.field_150360_v, 1, 1));
        for (String ore : OreDictionary.getOreNames()) {
            if (!ore.startsWith("dust")) continue;
            SmeltingBlacklist.addOres(ore);
        }
    }

    public static ICharacterClass getClassFromName(ResourceLocation name) {
        if (classMap.containsKey(name)) {
            return classMap.get(name);
        }
        return null;
    }

    public static IPlayerSkill getSkillFromName(ResourceLocation name) {
        if (skillHashMap.containsKey(name)) {
            return skillHashMap.get(name);
        }
        return null;
    }

    public static int getSkillLevel(EntityPlayer player, ResourceLocation skill) {
        return SkillRegistry.getPlayer(player).getSkillLevel(skill);
    }

    public static IPlayerClass getPlayer(EntityPlayer player) {
        return (IPlayerClass)player.getCapability(PlayerCapability.PLAYER_CLASS, null);
    }

    public static void addStackToOreBonus(String stack, int bonusXP) {
        oreBonusXP.put(stack, bonusXP);
    }

    public static Map<String, Integer> getOreBonusXP() {
        return oreBonusXP;
    }

    public static void addExperience(EntityPlayer player, int amount) {
        player.func_71023_q(amount);
    }

    public static boolean stackMatches(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        if (stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE) {
            return stack1.func_77973_b() == stack2.func_77973_b();
        }
        return stack1.func_77969_a(stack2);
    }

    public static boolean listContains(ItemStack stack, List<ItemStack> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (ItemStack lStack : list) {
            if (!SkillRegistry.stackMatches(stack, lStack)) continue;
            return true;
        }
        return false;
    }

    public static void loadPlayer(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            HashMap skills = Maps.newHashMap();
            for (ResourceLocation name : skillHashMap.keySet()) {
                int level = SkillRegistry.getPlayer(player).getSkillLevel(name, false);
                skills.put(name, level);
            }
            ResourceLocation cl = SkillRegistry.getPlayer(player).getPlayerClass();
            SkillPacketHandler.initChannel.sendTo(SkillPacketHandler.getSkillPacket(Side.CLIENT, 0, skills, SkillRegistry.getPlayer(player).getLevelBank(), cl), (EntityPlayerMP)player);
        }
    }

    public static void addCropsToBlacklist(List<String> blacklist) {
        for (String str : blacklist) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(str));
            if (block == null || block == Blocks.field_150350_a || !(block instanceof IPlantable)) continue;
            cropBlacklist.add((IPlantable)block);
        }
    }

    public static List<IPlantable> getCropBlacklist() {
        return cropBlacklist;
    }

    public static ItemStack getOreEntry(String ore) {
        if (OreDictionary.doesOreNameExist((String)ore) && !OreDictionary.getOres((String)ore).isEmpty()) {
            for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                if (!(stack.func_77973_b() instanceof ItemBlock) || stack.func_77942_o()) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static void initPlankCache() {
        PlankCache.refresh();
        for (ItemStack log : OreDictionary.getOres((String)"logWood")) {
            if (!(log.func_77973_b() instanceof ItemBlock)) continue;
            if (log.func_77960_j() == Short.MAX_VALUE) {
                for (int i = 0; i < 4; ++i) {
                    ItemStack logTest = new ItemStack(log.func_77973_b(), 1, i);
                    ItemStack plank = SkillRegistry.getPlankOutput(logTest);
                    if (plank.func_190926_b()) continue;
                    SkillRegistry.registerLog(logTest, plank);
                }
                continue;
            }
            ItemStack plank = SkillRegistry.getPlankOutput(log);
            if (plank.func_190926_b()) continue;
            SkillRegistry.registerLog(log, plank);
        }
    }

    private static void registerLog(ItemStack log, ItemStack plank) {
        Block block = ((ItemBlock)log.func_77973_b()).func_179223_d();
        ItemStack plankCopy = plank.func_77946_l();
        plankCopy.func_190920_e(plank.func_190916_E() / 2);
        PlankCache.addBlock(block, log.func_77960_j(), plankCopy);
    }

    private static ItemStack getPlankOutput(ItemStack log) {
        Iterator it = CraftingManager.field_193380_a.iterator();
        ItemStack stack = ItemStack.field_190927_a;
        while (it.hasNext() && stack.func_190926_b()) {
            IRecipe recipe = (IRecipe)it.next();
            NonNullList ing = recipe.func_192400_c();
            if (!SkillRegistry.isPlank(recipe.func_77571_b())) continue;
            for (Ingredient in : ing) {
                for (ItemStack check : in.func_193365_a()) {
                    if (!check.func_77969_a(log)) continue;
                    stack = recipe.func_77571_b().func_77946_l();
                }
            }
        }
        return stack;
    }

    private static boolean isPlank(ItemStack output) {
        for (ItemStack plank : OreDictionary.getOres((String)"plankWood")) {
            if (plank.func_77960_j() == Short.MAX_VALUE) {
                return output.func_77973_b() == plank.func_77973_b();
            }
            if (!plank.func_77969_a(output)) continue;
            return true;
        }
        return false;
    }

    public static void resetForNewProps() {
        skillHashMap.clear();
        classMap.clear();
        specializations.clear();
        specSkillCache.clear();
    }

    public static void addClass(ICharacterClass charClass) {
        classMap.put(charClass.getClassName(), charClass);
    }

    public static void addSkill(IPlayerSkill skill) {
        skillHashMap.put(skill.getSkillName(), skill);
    }

    public static Map<ResourceLocation, IPlayerSkill> getSkills() {
        return skillHashMap;
    }

    public static Map<ResourceLocation, ICharacterClass> getClasses() {
        return classMap;
    }

    public static List<ResourceLocation> getSpecializations() {
        return specializations;
    }

    public static List<IPlayerSkill> getSkillsForSpec(ResourceLocation location) {
        return specSkillCache.get(location);
    }

    public static void registerSkillProperties() {
        try {
            Files.walk(LevelUpConfig.skillDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(l -> SkillRegistry.loadSkillsFromJson(l));
            Files.walk(LevelUpConfig.classDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(l -> SkillRegistry.loadClassesFromJson(l));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SkillRegistry.calculateHighLow();
    }

    private static void loadSkillsFromJson(Path location) {
        if (!Files.exists(location, new LinkOption[0])) {
            return;
        }
        try (BufferedReader read = Files.newBufferedReader(location);){
            SkillProperties prop = SkillProperties.fromJson((JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)read, JsonObject.class));
            skillProperties.put(prop.getName(), prop);
            skillHashMap.put(prop.getName(), BaseSkill.fromProps(prop));
        }
        catch (JsonParseException | IOException | NullPointerException e) {
            e.printStackTrace();
        }
    }

    private static void loadClassesFromJson(Path location) {
        if (!Files.exists(location, new LinkOption[0])) {
            return;
        }
        try (BufferedReader read = Files.newBufferedReader(location);){
            ClassProperties prop = ClassProperties.fromJson((JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)read, JsonObject.class));
            classProperties.put(prop.getClassName(), prop);
            classMap.put(prop.getClassName(), BaseClass.fromProperties(prop));
        }
        catch (JsonParseException | IOException | NullPointerException e) {
            e.printStackTrace();
        }
    }

    public static ClassProperties getProperty(ICharacterClass cl) {
        return classProperties.get(cl.getClassName());
    }

    public static SkillProperties getProperty(IPlayerSkill skill) {
        return skillProperties.get(skill.getSkillName());
    }

    public static void calculateHighLow() {
        largestDisplayRow = 0;
        largestDisplayColumn = 0;
        smallestDisplayRow = 0;
        smallestDisplayColumn = 0;
        for (ResourceLocation skill : skillHashMap.keySet()) {
            IPlayerSkill sk = SkillRegistry.getSkillFromName(skill);
            if (sk == null) continue;
            if (!specializations.contains(sk.getSkillType())) {
                specializations.add(sk.getSkillType());
                specSkillCache.put(sk.getSkillType(), Lists.newArrayList());
            }
            SkillRegistry.getSkillsForSpec(sk.getSkillType()).add(sk);
            int column = sk.getSkillColumn();
            int row = sk.getSkillRow();
            if (column > largestDisplayColumn) {
                largestDisplayColumn = column;
            } else if (column < smallestDisplayColumn) {
                smallestDisplayColumn = column;
            }
            if (row > largestDisplayRow) {
                largestDisplayRow = row;
                continue;
            }
            if (row >= smallestDisplayRow) continue;
            smallestDisplayRow = row;
        }
    }
}

