/*
 * Decompiled with CFR 0.152.
 */
package levelup2.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class SkillProperties {
    private ResourceLocation skillName;
    private ResourceLocation skillType;
    private int[] levels;
    private ResourceLocation[] prerequisites;
    private int column;
    private int row;
    private boolean enabled;
    private boolean active;
    private ItemStack repStack = ItemStack.field_190927_a;

    public static SkillProperties fromJson(JsonObject obj) {
        int[] levels = SkillProperties.getLevels(obj);
        ResourceLocation skillName = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)obj, (String)"name"));
        ResourceLocation[] prerequisites = SkillProperties.getPrerequisites(obj);
        int column = JsonUtils.func_151208_a((JsonObject)obj, (String)"column", (int)0);
        int row = JsonUtils.func_151208_a((JsonObject)obj, (String)"row", (int)0);
        boolean enabled = JsonUtils.func_151209_a((JsonObject)obj, (String)"enabled", (boolean)true);
        boolean active = JsonUtils.func_151209_a((JsonObject)obj, (String)"active", (boolean)true);
        ResourceLocation type = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)obj, (String)"type"));
        ItemStack rep = ShapedRecipes.func_192405_a((JsonObject)JsonUtils.func_152754_s((JsonObject)obj, (String)"stack"), (boolean)false);
        return new SkillProperties(skillName, type, levels, prerequisites, column, row, enabled, active, rep);
    }

    public SkillProperties(ResourceLocation skillName, ResourceLocation skillType, int[] levelCosts, ResourceLocation[] prerequisites, int column, int row, boolean enabled, boolean active, ItemStack rep) {
        this.skillName = skillName;
        this.skillType = skillType;
        this.levels = levelCosts;
        this.prerequisites = prerequisites;
        this.column = column;
        this.row = row;
        this.enabled = enabled;
        this.active = active;
        this.repStack = rep;
    }

    public ResourceLocation getName() {
        return this.skillName;
    }

    public ResourceLocation getType() {
        return this.skillType;
    }

    public int[] getLevels() {
        return this.levels;
    }

    public ResourceLocation[] getPrerequisites() {
        return this.prerequisites;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isActive() {
        return this.active;
    }

    public ItemStack getRepStack() {
        return this.repStack;
    }

    public void writeToBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("name", this.skillName.toString());
        tag.func_74778_a("type", this.skillType.toString());
        if (this.getLevels() != null && this.getLevels().length > 0) {
            tag.func_74783_a("levels", this.getLevels());
        }
        if (this.getPrerequisites() != null && this.getPrerequisites().length > 0) {
            NBTTagCompound prereqs = new NBTTagCompound();
            prereqs.func_74774_a("Size", (byte)this.getPrerequisites().length);
            for (int i = 0; i < this.getPrerequisites().length; ++i) {
                ResourceLocation prereq = this.getPrerequisites()[i];
                prereqs.func_74778_a("prereq_" + i, prereq.toString());
            }
            tag.func_74782_a("prereqs", (NBTBase)prereqs);
        }
        tag.func_74768_a("column", this.getColumn());
        tag.func_74768_a("row", this.getRow());
        tag.func_74757_a("enabled", this.isEnabled());
        tag.func_74757_a("active", this.isActive());
        if (!this.repStack.func_190926_b()) {
            tag.func_74782_a("item", (NBTBase)this.repStack.serializeNBT());
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static SkillProperties fromNBT(NBTTagCompound tag) {
        ResourceLocation name = new ResourceLocation(tag.func_74779_i("name"));
        ResourceLocation type = new ResourceLocation(tag.func_74779_i("type"));
        int[] levels = tag.func_74764_b("levels") ? tag.func_74759_k("levels") : new int[]{};
        ResourceLocation[] prereqs = new ResourceLocation[]{};
        if (tag.func_74764_b("prereqs")) {
            NBTTagCompound prereq = tag.func_74775_l("prereqs");
            int size = prereq.func_74771_c("Size");
            prereqs = new ResourceLocation[size];
            for (int i = 0; i < size; ++i) {
                prereqs[i] = new ResourceLocation(prereq.func_74779_i("prereq_" + i));
            }
        }
        int column = tag.func_74762_e("column");
        int row = tag.func_74762_e("row");
        boolean enabled = tag.func_74767_n("enabled");
        boolean active = tag.func_74767_n("active");
        ItemStack stack = ItemStack.field_190927_a;
        if (tag.func_74764_b("item")) {
            stack = new ItemStack(tag.func_74775_l("item"));
        }
        return new SkillProperties(name, type, levels, prereqs, column, row, enabled, active, stack);
    }

    private static int[] getLevels(JsonObject obj) {
        JsonArray levels = JsonUtils.func_151213_a((JsonObject)obj, (String)"levels", null);
        if (levels != null) {
            ArrayList<Integer> lvl = new ArrayList<Integer>();
            for (JsonElement element : levels) {
                lvl.add(element.getAsInt());
            }
            int[] lvls = new int[lvl.size()];
            for (int i = 0; i < lvls.length; ++i) {
                lvls[i] = (Integer)lvl.get(i);
            }
            return lvls;
        }
        return new int[0];
    }

    private static ResourceLocation[] getPrerequisites(JsonObject obj) {
        JsonArray prereqs = JsonUtils.func_151213_a((JsonObject)obj, (String)"prerequisites", null);
        if (prereqs != null) {
            ArrayList<String> prereq = new ArrayList<String>();
            for (JsonElement element : prereqs) {
                prereq.add(element.getAsString());
            }
            ResourceLocation[] str = new ResourceLocation[prereq.size()];
            for (int i = 0; i < str.length; ++i) {
                str[i] = new ResourceLocation((String)prereq.get(i));
            }
            return str;
        }
        return new ResourceLocation[0];
    }
}

