/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.bees;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;

public class AlleleTemplate {
    final EnumMap<EnumBeeChromosome, IAllele> map = new EnumMap(EnumBeeChromosome.class);

    private AlleleTemplate(@Nullable IAlleleBeeSpecies beeSpecies) {
        if (beeSpecies != null) {
            this.setTemplateAllelle(EnumBeeChromosome.SPECIES, beeSpecies);
        }
        this.setTemplateAllelle(EnumBeeChromosome.SPEED, "forestry.speedSlow");
        this.setTemplateAllelle(EnumBeeChromosome.LIFESPAN, "forestry.lifespanLong");
        this.setTemplateAllelle(EnumBeeChromosome.FERTILITY, "forestry.fertilityNormal");
        this.setTemplateAllelle(EnumBeeChromosome.TEMPERATURE_TOLERANCE, "forestry.toleranceNone");
        this.setTemplateAllelle(EnumBeeChromosome.NEVER_SLEEPS, "forestry.boolFalse");
        this.setTemplateAllelle(EnumBeeChromosome.HUMIDITY_TOLERANCE, "forestry.toleranceNone");
        this.setTemplateAllelle(EnumBeeChromosome.TOLERATES_RAIN, "forestry.boolFalse");
        this.setTemplateAllelle(EnumBeeChromosome.CAVE_DWELLING, "forestry.boolFalse");
        this.setTemplateAllelle(EnumBeeChromosome.FLOWER_PROVIDER, "forestry.flowersVanilla");
        this.setTemplateAllelle(EnumBeeChromosome.FLOWERING, "forestry.floweringSlow");
        this.setTemplateAllelle(EnumBeeChromosome.TERRITORY, "forestry.territoryAverage");
        this.setTemplateAllelle(EnumBeeChromosome.EFFECT, "forestry.effectNone");
    }

    @Nonnull
    public static AlleleTemplate createAlleleTemplate(IAlleleBeeSpecies beeSpecies) {
        return new AlleleTemplate(beeSpecies);
    }

    public void register() {
        IAllele[] alleles = new IAllele[EnumBeeChromosome.values().length];
        for (int i = 0; i < alleles.length; ++i) {
            EnumBeeChromosome key = EnumBeeChromosome.values()[i];
            if (!this.map.containsKey(key)) {
                throw new IllegalStateException(key + " entry not found");
            }
            alleles[i] = this.map.get(key);
        }
        BeeManager.beeRoot.registerTemplate(alleles);
    }

    @Nonnull
    public IAlleleBeeEffect getEffect() {
        return this.getValue(EnumBeeChromosome.EFFECT, IAlleleBeeEffect.class);
    }

    @Nonnull
    public <T extends IAllele> T getValue(@Nonnull EnumBeeChromosome chromosome, @Nonnull Class<T> clazz) {
        Validate.isTrue((boolean)chromosome.getAlleleClass().isAssignableFrom(clazz));
        IAllele iAllele = this.map.get(chromosome);
        return (T)iAllele;
    }

    @Nonnull
    public AlleleTemplate setTemplateAllelle(@Nonnull EnumBeeChromosome chromosome, Object value) {
        if (value instanceof IAllele) {
            this.map.put(chromosome, (IAllele)value);
            return this;
        }
        if (value instanceof String) {
            for (IAllele iAllele : AlleleManager.alleleRegistry.getRegisteredAlleles((IChromosomeType)chromosome)) {
                if (!value.equals(iAllele.getUID())) continue;
                this.map.put(chromosome, iAllele);
                return this;
            }
            for (IAllele iAllele : AlleleManager.alleleRegistry.getRegisteredAlleles((IChromosomeType)chromosome)) {
                if (!iAllele.getModID().equals("forestry") || !iAllele.getUID().contains((String)value)) continue;
                this.map.put(chromosome, iAllele);
                return this;
            }
            String s = AlleleManager.alleleRegistry.getRegisteredAlleles((IChromosomeType)chromosome).stream().map(IAllele::getUID).collect(StringBuilder::new, (stringBuilder, str) -> stringBuilder.append((String)str).append(' '), StringBuilder::append).toString();
            throw new RuntimeException("Error[" + value + "] + " + chromosome + " {" + s + "}");
        }
        throw new RuntimeException("Error[" + value + "] + " + chromosome);
    }
}

