/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.blocks;

import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.bees.CareerBeeEntry;
import com.rwtema.careerbees.blocks.TileFlowerPedastal;
import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.items.ItemIngredients;
import com.rwtema.careerbees.lang.Lang;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFlowerPedastal
extends Block {
    public static final IProperty<PlantType> PLANT_TYPE = PropertyEnum.func_177709_a((String)"type", PlantType.class);

    public BlockFlowerPedastal() {
        super(Material.field_151585_k);
        this.func_149663_c("careerbees:flower_pedastal");
        this.setRegistryName("careerbees:flower_pedastal");
        this.func_149647_a(BeeMod.creativeTab);
    }

    public static void sendPulse(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleType particleType) {
        world.func_175641_c(pos, (Block)BeeMod.instance.plantFrame, particleType.ordinal(), 0);
    }

    public static void sendPulse(@Nonnull TileFlowerPedastal plantFrame, @Nonnull ParticleType particleType) {
        BlockFlowerPedastal.sendPulse(plantFrame.func_145831_w(), plantFrame.func_174877_v(), particleType);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PLANT_TYPE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PLANT_TYPE, (Comparable)((Object)(meta == 1 ? PlantType.ADVANCED : PlantType.BASIC)));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((PlantType)((Object)state.func_177229_b(PLANT_TYPE))).ordinal();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileFlowerPedastal();
    }

    public boolean func_180639_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof TileFlowerPedastal)) {
            return true;
        }
        TileFlowerPedastal flowerPedastal = (TileFlowerPedastal)tileEntity;
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (ItemIngredients.IngredientType.PHEREMONES.test(heldItem) && flowerPedastal.speciesType.isEmpty() && heldItem.func_77978_p() != null) {
            IAlleleBeeEffect iAlleleBeeEffect;
            String species = heldItem.func_77978_p().func_74779_i("species");
            IAlleleBeeSpecies checkSpecies = CareerBeeEntry.CustomBeeFactory.STRING_SPECIES_MAP.get(species);
            if (checkSpecies != null && (iAlleleBeeEffect = CareerBeeEntry.CustomBeeFactory.SPECIES_EFFECT_MAP.get(checkSpecies)) instanceof EffectBase && ((EffectBase)iAlleleBeeEffect).canAcceptItems()) {
                flowerPedastal.speciesType = species;
                worldIn.func_184138_a(pos, Blocks.field_150350_a.func_176223_P(), state, 0);
                heldItem.func_190918_g(1);
                return true;
            }
            playerIn.func_145747_a((ITextComponent)Lang.chat("This species does not use flower pedastals", new Object[0]));
            return true;
        }
        ItemStack plantFrameStack = flowerPedastal.getStack();
        if (heldItem.func_190926_b() && !plantFrameStack.func_190926_b()) {
            playerIn.func_184611_a(hand, plantFrameStack.func_77946_l());
            flowerPedastal.setStack(ItemStack.field_190927_a);
        } else if (!heldItem.func_190926_b()) {
            if (!flowerPedastal.canAcceptStack(heldItem)) {
                return true;
            }
            if (!plantFrameStack.func_190926_b()) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)plantFrameStack.func_77946_l());
            }
            flowerPedastal.setStack(heldItem.func_77979_a(1));
        }
        worldIn.func_184138_a(pos, Blocks.field_150350_a.func_176223_P(), state, 0);
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_189539_a(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, int id, int param) {
        if (worldIn.field_72995_K) {
            ParticleType particleType = ParticleType.values()[id];
            switch (particleType) {
                case YELLOW: {
                    for (int i = 0; i < 10; ++i) {
                        double x = (double)pos.func_177958_n() + worldIn.field_73012_v.nextDouble();
                        double y = (double)pos.func_177956_o() + worldIn.field_73012_v.nextDouble();
                        double z = (double)pos.func_177952_p() + worldIn.field_73012_v.nextDouble();
                        worldIn.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, 1.0, 0.9, 0.01, new int[0]);
                    }
                    break;
                }
                case FIRE: {
                    for (int i = 0; i < 10; ++i) {
                        double x = (double)pos.func_177958_n() + worldIn.field_73012_v.nextDouble();
                        double y = (double)pos.func_177956_o() + worldIn.field_73012_v.nextDouble();
                        double z = (double)pos.func_177952_p() + worldIn.field_73012_v.nextDouble();
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                    }
                    break;
                }
            }
        }
        return true;
    }

    public void func_180655_c(IBlockState stateIn, @Nonnull World worldIn, @Nonnull BlockPos pos, Random rand) {
        if (worldIn.func_82737_E() % 8L > 0L) {
            return;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof TileFlowerPedastal)) {
            return;
        }
        String speciesType = ((TileFlowerPedastal)tileEntity).speciesType;
        if (speciesType.isEmpty()) {
            return;
        }
        IAllele species = AlleleManager.alleleRegistry.getAllele(speciesType);
        if (!(species instanceof IAlleleBeeSpecies)) {
            return;
        }
        double x = (double)pos.func_177958_n() + worldIn.field_73012_v.nextDouble();
        double y = (double)pos.func_177956_o() + worldIn.field_73012_v.nextDouble() / 16.0;
        double z = (double)pos.func_177952_p() + worldIn.field_73012_v.nextDouble();
        int color = ((IAlleleBeeSpecies)species).getSpriteColour(worldIn.field_73012_v.nextInt(2));
        double r = (double)(color >> 16 & 0xFF) / 255.0;
        double g = (double)(color >> 8 & 0xFF) / 255.0;
        double b = (double)(color & 0xFF) / 255.0;
        worldIn.func_175688_a(EnumParticleTypes.SPELL_MOB_AMBIENT, x, y, z, r, g, b, new int[0]);
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileFlowerPedastal plantFrame;
        ItemStack plantFrameStack;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileFlowerPedastal && !(plantFrameStack = (plantFrame = (TileFlowerPedastal)tileEntity).getStack()).func_190926_b()) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)plantFrameStack.func_77946_l());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public static enum PlantType implements IStringSerializable
    {
        BASIC,
        ADVANCED;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum ParticleType {
        YELLOW,
        FIRE;

    }
}

