/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.google.common.collect.Lists;
import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.effects.EffectBaseThrottled;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EffectCreeper
extends EffectBaseThrottled {
    public static final EffectBase INSTANCE = new EffectCreeper("creeper", 2, 0.2f);

    public EffectCreeper(String name, int baseTicksBetweenProcessing, float chanceOfProcessing) {
        super(name, baseTicksBetweenProcessing, chanceOfProcessing);
    }

    public EffectCreeper(String name, float baseTicksBetweenProcessing) {
        super(name, baseTicksBetweenProcessing);
    }

    @Override
    public void performEffect(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, @Nonnull Random random, World world, BlockPos pos, IBeeModifier beeHousingModifier, IBeeModifier beeModeModifier, IEffectSettingsHolder settings) {
        AxisAlignedBB aabb = EffectCreeper.getAABB(genome, housing);
        if (world.func_72872_a(EntityCreeper.class, aabb).size() > 20) {
            return;
        }
        Vec3d territory = EffectCreeper.getTerritory(genome, housing);
        double x = (double)pos.func_177958_n() + (random.nextDouble() - random.nextDouble()) * territory.field_72450_a + 0.5;
        double y = pos.func_177956_o() + random.nextInt(3) - 1;
        double z = (double)pos.func_177952_p() + (random.nextDouble() - random.nextDouble()) * territory.field_72449_c + 0.5;
        EntityCreeper entityCreeper = new EntityCreeper(world);
        entityCreeper.func_70012_b(x, y, z, entityCreeper.field_70177_z, entityCreeper.field_70125_A);
        if (!entityCreeper.func_70058_J()) {
            return;
        }
        if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityCreeper, (World)world, (float)((float)x), (float)((float)y), (float)((float)z), null)) {
            entityCreeper.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityCreeper)), null);
        }
        PotionEffect potioneffectIn = new PotionEffect(MobEffects.field_82731_v, 1000, 0);
        potioneffectIn.setCurativeItems((List)Lists.newArrayList());
        entityCreeper.func_70690_d(potioneffectIn);
        NBTTagCompound compound = new NBTTagCompound();
        entityCreeper.func_70014_b(compound);
        compound.func_74774_a("ExplosionRadius", (byte)5);
        compound.func_74778_a("DeathLootTable", "minecraft:empty");
        entityCreeper.func_70037_a(compound);
        world.func_72838_d((Entity)entityCreeper);
    }
}

