/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.mojang.realmsclient.gui.ChatFormatting;
import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.blocks.TileFlowerPedastal;
import com.rwtema.careerbees.effects.EffectFoodModify;
import com.rwtema.careerbees.lang.Lang;
import forestry.api.apiculture.IBeeGenome;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EffectHoneyGlaze
extends EffectFoodModify {
    public static final EffectHoneyGlaze INSTANCE = new EffectHoneyGlaze("glazing", 60.0f);

    public EffectHoneyGlaze(String name, float baseTicksBetweenProcessing) {
        super(name, baseTicksBetweenProcessing);
    }

    public EffectHoneyGlaze(String name, boolean isDominant, boolean isCombinable, float baseTicksBetweenProcessing, float chanceOfProcessing) {
        super(name, isDominant, isCombinable, baseTicksBetweenProcessing, chanceOfProcessing);
    }

    @Override
    protected boolean shouldBeginEattingOverride(@Nonnull EntityPlayer entityPlayer, ItemStack itemStack, @Nonnull NBTTagCompound compoundTag) {
        return compoundTag.func_74760_g("current") > entityPlayer.func_110139_bj();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addTooltip(ItemStack itemStack, @Nonnull NBTTagCompound tag, @Nonnull List<String> toolTip) {
        float current = tag.func_74760_g("current");
        if (current > 0.0f) {
            toolTip.add(ChatFormatting.YELLOW + Lang.translateArgs("Honey Glazing: %s Absorbtion Hearts", NumberFormat.getInstance(Locale.UK).format(current / 2.0f)));
        }
    }

    @Override
    public void callback(@Nonnull EntityPlayer player, @Nonnull NBTTagCompound tag, ItemStack item) {
        float max = tag.func_74760_g("current");
        float absorptionAmount = player.func_110139_bj();
        if (absorptionAmount < max) {
            player.func_110149_m(max);
        }
    }

    @Override
    protected boolean shouldRelease(IBeeGenome genome, TileFlowerPedastal frame, @Nonnull NBTTagCompound curTag) {
        return curTag.func_74760_g("current") >= curTag.func_74760_g("max");
    }

    @Override
    @Nullable
    protected NBTTagCompound addData(IBeeGenome genome, @Nonnull ItemStack stack, @Nullable NBTTagCompound prevTag) {
        float current = prevTag != null ? prevTag.func_74760_g("current") : 0.0f;
        ItemFood food = (ItemFood)stack.func_77973_b();
        float max = Math.min((float)this.getMax(genome), EffectHoneyGlaze.calcMaxUnbound(stack, food));
        float newCurrent = Math.min(current + 1.0f, max);
        if (current >= max) {
            return null;
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74776_a("current", newCurrent);
        nbtTagCompound.func_74776_a("max", max);
        return nbtTagCompound;
    }

    private static float calcMaxUnbound(ItemStack stack, @Nonnull ItemFood food) {
        return (float)Math.round(25.0f * (float)food.func_150905_g(stack) * food.func_150906_h(stack) / 2.0f) / 4.0f;
    }

    @Override
    public boolean acceptItemStack(ItemStack stack, @Nullable NBTTagCompound curTag) {
        return curTag == null || curTag.func_74760_g("current") < curTag.func_74760_g("max");
    }

    protected int getMax(IBeeGenome genome) {
        return 20;
    }

    static {
        if (BeeMod.deobf) {
            StreamSupport.stream(ItemFood.field_150901_e.spliterator(), false).filter(item -> item instanceof ItemFood).flatMap(item -> {
                NonNullList list = NonNullList.func_191196_a();
                item.func_150895_a(CreativeTabs.field_78027_g, list);
                return list.stream();
            }).forEach(stack -> BeeMod.logger.info(stack.func_82833_r() + " " + EffectHoneyGlaze.calcMaxUnbound(stack, (ItemFood)stack.func_77973_b())));
        }
    }
}

