/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.effects.EffectBaseThrottled;
import com.rwtema.careerbees.effects.ISpecialBeeEffect;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import com.rwtema.careerbees.helpers.ParticleHelper;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.genetics.IEffectData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class EffectSteal<T extends EntityLivingBase>
extends EffectBaseThrottled
implements ISpecialBeeEffect.SpecialEffectEntity {
    public EffectSteal(String steal, int baseTicksBetweenProcessing) {
        super(steal, true, false, baseTicksBetweenProcessing, 1.0f);
    }

    public static void mergeStackIntoList(@Nonnull List<ItemStack> grabbed_stacks, @Nonnull ItemStack addedStack) {
        for (ItemStack grabbed_stack : grabbed_stacks) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)addedStack, (ItemStack)grabbed_stack)) continue;
            grabbed_stack.func_190917_f(addedStack.func_190916_E());
            return;
        }
        grabbed_stacks.add(addedStack.func_77946_l());
    }

    @Override
    public void performEffect(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, @Nonnull Random random, @Nonnull World world, BlockPos pos, IBeeModifier beeHousingModifier, IBeeModifier beeModeModifier, IEffectSettingsHolder settings) {
        AxisAlignedBB bb = EffectSteal.getAABB(genome, housing);
        ArrayList entitiesWithinAABB = new ArrayList(world.func_72872_a(this.getEntityClazz(), bb));
        Collections.shuffle(entitiesWithinAABB, random);
        for (EntityLivingBase livingBase : entitiesWithinAABB) {
            int count;
            if (random.nextBoolean() || !this.canHandle(livingBase) || (count = BeeManager.armorApiaristHelper.wearsItems(livingBase, this.getUID(), true)) > 0 || !this.steal(livingBase, housing, this)) continue;
            return;
        }
    }

    protected abstract boolean steal(T var1, IBeeHousing var2, EffectSteal var3);

    protected abstract boolean canHandle(T var1);

    protected abstract Class<T> getEntityClazz();

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public IEffectData doFX(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing) {
        IBeekeepingLogic beekeepingLogic = housing.getBeekeepingLogic();
        ArrayList<BlockPos> flowerPositions = new ArrayList<BlockPos>(beekeepingLogic.getFlowerPositions());
        AxisAlignedBB bb = EffectSteal.getAABB(genome, housing);
        HashSet<BlockPos> pos = new HashSet<BlockPos>(flowerPositions);
        for (EntityLivingBase entityLivingBase : housing.getWorldObj().func_72872_a(this.getEntityClazz(), bb)) {
            BlockPos e;
            int count;
            if (!this.canHandle(entityLivingBase) || (count = BeeManager.armorApiaristHelper.wearsItems(entityLivingBase, this.getUID(), true)) > 0 || !pos.add(e = new BlockPos(entityLivingBase.field_70165_t, entityLivingBase.field_70163_u + (double)entityLivingBase.func_70047_e(), entityLivingBase.field_70161_v))) continue;
            flowerPositions.add(e);
        }
        ParticleHelper.BEE_HIVE_FX.addBeeHiveFX(housing, genome, flowerPositions);
        return storedData;
    }

    @Override
    public boolean canHandleEntity(Entity livingBase, @Nonnull IBeeGenome genome) {
        return this.getEntityClazz().isInstance(livingBase);
    }

    @Override
    public boolean handleEntityLiving(@Nonnull Entity livingBase, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        if (this.getEntityClazz().isInstance(livingBase)) {
            int count;
            EntityLivingBase t = (EntityLivingBase)this.getEntityClazz().cast(livingBase);
            if (this.canHandle(t) && ((count = BeeManager.armorApiaristHelper.wearsItems((EntityLivingBase)this.getEntityClazz().cast(livingBase), this.getUID(), true)) > 0 || this.steal(t, housing, this))) {
                return true;
            }
            return true;
        }
        return false;
    }
}

