/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.recipes;

import com.rwtema.careerbees.recipes.BeeCraftingInputEntry;
import com.rwtema.careerbees.recipes.IBeeCraftingRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class BeeCraftingRecipe
implements IBeeCraftingRecipe {
    public static final List<IBeeCraftingRecipe> RECIPES = new ArrayList<IBeeCraftingRecipe>();
    private final List<BeeCraftingInputEntry> inputs;
    private final ItemStack output;

    public BeeCraftingRecipe(ItemStack output, Object ... inputObjects) {
        this.inputs = new ArrayList<BeeCraftingInputEntry>();
        this.output = output;
        for (Object input : inputObjects) {
            if (input instanceof Item) {
                this.inputs.add(BeeCraftingRecipe.createWrapper((Item)input));
                continue;
            }
            if (input instanceof ItemStack) {
                int metadata = ((ItemStack)input).func_77960_j();
                if (metadata == Short.MAX_VALUE) {
                    this.inputs.add(BeeCraftingRecipe.createWrapper(((ItemStack)input).func_77973_b()));
                    continue;
                }
                this.inputs.add(BeeCraftingRecipe.createWrapper(((ItemStack)input).func_77973_b(), metadata));
                continue;
            }
            if (input instanceof List) {
                this.inputs.add(BeeCraftingRecipe.createWrapper((List)input));
                continue;
            }
            if (!(input instanceof String)) continue;
            this.inputs.add(BeeCraftingRecipe.createWrapper((String)input));
        }
    }

    protected BeeCraftingRecipe(List<BeeCraftingInputEntry> inputs, ItemStack output) {
        this.inputs = inputs;
        this.output = output;
    }

    @Nonnull
    public static BeeCraftingInputEntry createWrapper(final @Nonnull Item item) {
        return new BeeCraftingInputEntry(){

            @Override
            public boolean test(@Nonnull ItemStack stack) {
                return stack.func_77973_b() == item;
            }

            @Override
            @Nonnull
            public List<ItemStack> getJEIInputs() {
                NonNullList list = NonNullList.func_191196_a();
                item.func_150895_a(item.func_77640_w(), list);
                return list;
            }
        };
    }

    @Nonnull
    public static BeeCraftingInputEntry createWrapper(String oreName) {
        return BeeCraftingRecipe.createWrapper((List<ItemStack>)OreDictionary.getOres((String)oreName));
    }

    @Nonnull
    public static BeeCraftingInputEntry createWrapper(final @Nonnull List<ItemStack> list) {
        return new BeeCraftingInputEntry(){

            @Override
            public boolean test(@Nonnull ItemStack stack) {
                for (ItemStack matchStack : list) {
                    if (!OreDictionary.itemMatches((ItemStack)matchStack, (ItemStack)stack, (boolean)false)) continue;
                    return true;
                }
                return false;
            }

            @Override
            @Nonnull
            public List<ItemStack> getJEIInputs() {
                return list;
            }
        };
    }

    @Nonnull
    public static BeeCraftingInputEntry createWrapper(final @Nonnull Item item, final int meta) {
        return new BeeCraftingInputEntry(){

            @Override
            public boolean test(@Nonnull ItemStack stack) {
                return stack.func_77973_b() == item && stack.func_77960_j() == meta;
            }

            @Override
            @Nonnull
            public List<ItemStack> getJEIInputs() {
                return Collections.singletonList(new ItemStack(item, 1, meta));
            }
        };
    }

    @Override
    public ItemStack getOutput(Map<BeeCraftingInputEntry, ItemStack> inputs) {
        return this.output;
    }

    @Override
    public List<BeeCraftingInputEntry> getInputs() {
        return this.inputs;
    }
}

