/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.recipes;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.rwtema.careerbees.BeeMod;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;

public abstract class OreConversion {
    final LoadingCache<Item, Map<Integer, ItemStack>> cache = CacheBuilder.newBuilder().maximumSize(60L).build((CacheLoader)new CacheLoader<Item, Map<Integer, ItemStack>>(){

        public Map<Integer, ItemStack> load(@Nonnull Item item) throws Exception {
            ImmutableSet metas;
            ImmutableList stacks = OreConversion.this.getStacks(item);
            if (stacks.isEmpty()) {
                stacks = ImmutableList.of((Object)new ItemStack(item));
            }
            if (item.func_77614_k()) {
                metas = (ImmutableSet)stacks.stream().filter(stack -> !stack.func_77942_o()).map(ItemStack::func_77960_j).collect(ImmutableSet.toImmutableSet());
                if (metas.isEmpty()) {
                    metas = ImmutableSet.of((Object)0);
                }
            } else {
                metas = ImmutableSet.of((Object)0);
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Integer meta : metas) {
                int[] oreIDs = OreDictionary.getOreIDs((ItemStack)new ItemStack(item, 1, meta.intValue()));
                if (oreIDs.length == 0) continue;
                Arrays.stream(oreIDs).mapToObj(OreDictionary::getOreName).map(OreConversion.this::getOreMapping).filter(Objects::nonNull).distinct().flatMap(t -> OreDictionary.getOres((String)t).stream()).sorted(Comparator.comparing(t -> !Objects.equals(((ResourceLocation)Validate.notNull((Object)t.func_77973_b().getRegistryName())).func_110624_b(), ((ResourceLocation)Validate.notNull((Object)item.getRegistryName())).func_110624_b()))).findFirst().ifPresent(s -> builder.put((Object)meta, (Object)s.func_77946_l()));
            }
            return builder.build();
        }
    });

    public OreConversion() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void run(OreDictionary.OreRegisterEvent event) {
        this.cache.invalidateAll();
    }

    public boolean isValid(@Nonnull ItemStack itemStack) {
        Map map = (Map)this.cache.getUnchecked((Object)itemStack.func_77973_b());
        return map.containsKey(itemStack.func_77960_j());
    }

    public ItemStack get(@Nonnull ItemStack itemStack) {
        return this.get(itemStack, ItemStack.field_190927_a);
    }

    public ItemStack get(@Nonnull ItemStack itemStack, ItemStack emptyReturn) {
        Map map = (Map)this.cache.getUnchecked((Object)itemStack.func_77973_b());
        if (map.isEmpty()) {
            return emptyReturn;
        }
        ItemStack stack = (ItemStack)map.get(itemStack.func_77960_j());
        if (stack == null) {
            return emptyReturn;
        }
        return stack.func_77946_l();
    }

    @Nullable
    public abstract String getOreMapping(String var1);

    @Nonnull
    public NonNullList<ItemStack> getStacks(@Nonnull Item item) {
        NonNullList objects = NonNullList.func_191196_a();
        item.func_150895_a(CreativeTabs.field_78027_g, objects);
        return objects;
    }

    public void test() {
        this.cache.invalidateAll();
        StreamSupport.stream(ForgeRegistries.ITEMS.spliterator(), false).map(this::getStacks).flatMap(Collection::stream).forEach(stack -> {
            ItemStack itemStack = this.get((ItemStack)stack);
            if (!itemStack.func_190926_b()) {
                BeeMod.logger.info("Conv " + stack.func_82833_r() + " -> " + itemStack.func_82833_r());
            }
        });
        this.cache.invalidateAll();
    }

    public static class PrefixReplace
    extends OreConversion {
        final String inPrefix;
        final String outPrefix;

        public PrefixReplace(String inPrefix, String outPrefix) {
            this.inPrefix = inPrefix;
            this.outPrefix = outPrefix;
        }

        @Override
        @Nullable
        public String getOreMapping(@Nonnull String input) {
            if (input.length() > this.inPrefix.length() && input.startsWith(this.inPrefix) && Character.isUpperCase(input.charAt(this.inPrefix.length()))) {
                return this.outPrefix + input.substring(this.inPrefix.length());
            }
            return null;
        }
    }
}

