/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.block;

import com.someguyssoftware.gottschcore.block.ModFallingBlock;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.IFogSupport;
import com.someguyssoftware.treasure2.enums.FogHeight;
import com.someguyssoftware.treasure2.enums.FogType;
import com.someguyssoftware.treasure2.item.TreasureItems;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FogBlock
extends ModFallingBlock {
    public static final PropertyBool DECAYABLE = PropertyBool.func_177716_a((String)"decayable");
    public static final PropertyBool CHECK_DECAY = PropertyBool.func_177716_a((String)"check_decay");
    public static final PropertyBool ACTIVATED = PropertyBool.func_177716_a((String)"activated");
    protected static final AxisAlignedBB FULL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB HIGH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    protected static final AxisAlignedBB MED_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB LOW_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    public FogType fogType;
    public FogHeight fogHeight;
    public Map<FogHeight, FogBlock> fogMap;

    public FogBlock(String modID, String name, Material material, Map<FogHeight, FogBlock> map) {
        super(modID, name, material);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DECAYABLE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(false)));
        this.setNormalCube(false);
        this.setSoundType(SoundType.field_185856_i);
        this.func_149647_a(Treasure.TREASURE_TAB);
        this.setFogType(FogType.NORMAL);
        this.setFogHeight(FogHeight.FULL_FOG);
        this.setFogMap(map);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch (this.getFogHeight()) {
            case FULL_FOG: {
                return FULL_AABB;
            }
            case HIGH_FOG: {
                return HIGH_AABB;
            }
            case MEDIUM_FOG: {
                return MED_AABB;
            }
            case LOW_FOG: {
                return LOW_AABB;
            }
        }
        return FULL_AABB;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        worldIn.func_175656_a(pos, this.func_176223_P());
        IBlockState def = worldIn.func_180495_p(pos);
        Treasure.logger.debug("Default State FogBlock Placed @ {}. CD: {}, D: {}", (Object)pos.toString(), (Object)def.func_177229_b((IProperty)CHECK_DECAY), (Object)def.func_177229_b((IProperty)DECAYABLE));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkFallable(worldIn, pos);
    }

    public int func_149738_a(World worldIn) {
        return 2;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public static boolean canFallThrough(IBlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151579_a;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (WorldInfo.isServerSide((World)worldIn)) {
            if (((Boolean)state.func_177229_b((IProperty)CHECK_DECAY)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)DECAYABLE)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
                int z;
                int y;
                boolean isSupported = false;
                int x = pos.func_177958_n();
                if (worldIn.func_175707_a(new BlockPos(x - 5, (y = pos.func_177956_o()) - 5, (z = pos.func_177952_p()) - 5), new BlockPos(x + 5, y + 5, z + 5))) {
                    BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos();
                    block0: for (int x1 = -4; x1 <= 4; ++x1) {
                        for (int y1 = -4; y1 <= 4; ++y1) {
                            for (int z1 = -4; z1 <= 4; ++z1) {
                                IBlockState inspectBlockState = worldIn.func_180495_p((BlockPos)mbp.func_181079_c(x + x1, y + y1, z + z1));
                                Block inspectBlock = inspectBlockState.func_177230_c();
                                if (inspectBlock instanceof BlockTorch) {
                                    worldIn.func_175698_g(pos);
                                    return;
                                }
                                if (!(inspectBlock instanceof IFogSupport) || !((IFogSupport)inspectBlock).canSustainFog(inspectBlockState, (IBlockAccess)worldIn, (BlockPos)mbp.func_181079_c(x + x1, y + y1, z + z1))) continue;
                                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf(false)), 3);
                                isSupported = true;
                                break block0;
                            }
                        }
                    }
                    if (!isSupported) {
                        int fogCount = 0;
                        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() == TreasureItems.FOG) {
                            ++fogCount;
                        }
                        if (worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == TreasureItems.FOG) {
                            ++fogCount;
                        }
                        if (worldIn.func_180495_p(pos.func_177978_c()).func_185904_a() == TreasureItems.FOG) {
                            ++fogCount;
                        }
                        if (worldIn.func_180495_p(pos.func_177968_d()).func_185904_a() == TreasureItems.FOG) {
                            ++fogCount;
                        }
                        if (worldIn.func_180495_p(pos.func_177974_f()).func_185904_a() == TreasureItems.FOG) {
                            ++fogCount;
                        }
                        if (worldIn.func_180495_p(pos.func_177976_e()).func_185904_a() == TreasureItems.FOG) {
                            ++fogCount;
                        }
                        if (fogCount < 4) {
                            if (((FogBlock)state.func_177230_c()).getFogHeight() == FogHeight.FULL_FOG) {
                                worldIn.func_175656_a(pos, this.getFogMap().get((Object)FogHeight.HIGH_FOG).func_176223_P().func_177226_a((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf(true)));
                            } else if (((FogBlock)state.func_177230_c()).getFogHeight() == FogHeight.HIGH_FOG) {
                                worldIn.func_175656_a(pos, this.getFogMap().get((Object)FogHeight.MEDIUM_FOG).func_176223_P().func_177226_a((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf(true)));
                            } else if (((FogBlock)state.func_177230_c()).getFogHeight() == FogHeight.MEDIUM_FOG) {
                                worldIn.func_175656_a(pos, this.getFogMap().get((Object)FogHeight.LOW_FOG).func_176223_P().func_177226_a((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf(true)));
                            } else if (((FogBlock)state.func_177230_c()).getFogHeight() == FogHeight.LOW_FOG) {
                                worldIn.func_175698_g(pos);
                                return;
                            }
                        }
                    }
                }
            }
            if (((Boolean)state.func_177229_b((IProperty)DECAYABLE)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }

    private void checkFallable(World worldIn, BlockPos pos) {
        if ((worldIn.func_175623_d(pos.func_177977_b()) || FogBlock.canFallThrough(worldIn.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            int RADIUS = 32;
            if (worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32)) && WorldInfo.isServerSide((World)worldIn)) {
                EntityFallingBlock entityfallingblock = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos).func_177226_a((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(false)));
                worldIn.func_72838_d((Entity)entityfallingblock);
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DECAYABLE, CHECK_DECAY, ACTIVATED});
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return false;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        if (blockState != iblockstate) {
            return true;
        }
        if (block == this) {
            return false;
        }
        return false;
    }

    protected boolean func_149700_E() {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DECAYABLE, (Comparable)Boolean.valueOf((meta & 1) > 0)).func_177226_a((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf((meta & 2) > 0)).func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)DECAYABLE)).booleanValue()) {
            meta = 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)CHECK_DECAY)).booleanValue()) {
            meta += 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
            meta += 4;
        }
        return meta;
    }

    public FogHeight getFogHeight() {
        return this.fogHeight;
    }

    public FogBlock setFogHeight(FogHeight fog) {
        this.fogHeight = fog;
        return this;
    }

    public Map<FogHeight, FogBlock> getFogMap() {
        return this.fogMap;
    }

    public void setFogMap(Map<FogHeight, FogBlock> fogMap) {
        this.fogMap = fogMap;
    }

    public FogType getFogType() {
        return this.fogType;
    }

    public FogBlock setFogType(FogType fogType) {
        this.fogType = fogType;
        return this;
    }
}

