/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.block;

import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.particle.PoisonMistParticle;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SpanishMossBlock
extends BlockBush {
    public static final PropertyBool ACTIVATED = PropertyBool.func_177716_a((String)"activated");

    public SpanishMossBlock(String modID, String name) {
        super(Material.field_151575_d);
        this.setRegistryName(modID, name);
        this.func_149663_c(this.getRegistryName().toString());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVATED});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        if (WorldInfo.isServerSide((World)world)) {
            return;
        }
        if (!TreasureConfig.WORLD_GEN.getGeneralProperties().enableFog) {
            return;
        }
        if (!((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
            return;
        }
        if (RandomHelper.checkProbability((Random)random, (double)75.0)) {
            return;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        double xPos = x;
        double yPos = y;
        double zPos = z;
        double velocityX = 0.0;
        double velocityY = 0.0;
        double velocityZ = 0.0;
        PoisonMistParticle mistParticle = new PoisonMistParticle(world, xPos, yPos, zPos, velocityX, velocityY, velocityZ, (ICoords)new Coords(pos)){

            @Override
            public float provideGravity() {
                return 1.0E-4f;
            }

            @Override
            public float provideAlpha() {
                return 0.1f;
            }

            @Override
            public float provideMaxScale() {
                return 10.0f;
            }

            @Override
            public void doPlayerCollisions(World world) {
            }
        };
        mistParticle.init();
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)mistParticle);
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        return this.func_185514_i(worldIn.func_180495_p(pos.func_177977_b()));
    }

    public boolean func_185514_i(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf((meta & 1) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
            meta = 1;
        }
        return meta;
    }
}

