/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.capability;

import com.someguyssoftware.treasure2.capability.IKeyRingCapability;
import com.someguyssoftware.treasure2.capability.KeyRingCapability;
import com.someguyssoftware.treasure2.inventory.KeyRingInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class KeyRingCapabilityProvider
implements ICapabilityProvider,
ICapabilitySerializable<NBTTagCompound> {
    private static final String INVENTORY_TAG = "inventory";
    private static final String STATE_TAG = "state";
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> KEY_RING_INVENTORY_CAPABILITY = null;
    @CapabilityInject(value=IKeyRingCapability.class)
    public static Capability<IKeyRingCapability> KEY_RING_CAPABILITY = null;
    private final ItemStackHandler inventory_instance = new ItemStackHandler(KeyRingInventory.INVENTORY_SIZE);
    private final KeyRingCapability instance = new KeyRingCapability();

    public NBTTagCompound serializeNBT() {
        NBTTagCompound parentTag = new NBTTagCompound();
        NBTTagCompound inventoryTag = this.inventory_instance.serializeNBT();
        parentTag.func_74782_a(INVENTORY_TAG, (NBTBase)inventoryTag);
        NBTTagCompound stateTag = (NBTTagCompound)KEY_RING_CAPABILITY.getStorage().writeNBT(KEY_RING_CAPABILITY, (Object)this.instance, null);
        parentTag.func_74782_a(STATE_TAG, (NBTBase)stateTag);
        return parentTag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.inventory_instance.deserializeNBT(nbt.func_74775_l(INVENTORY_TAG));
        KEY_RING_CAPABILITY.getStorage().readNBT(KEY_RING_CAPABILITY, (Object)this.instance, null, (NBTBase)nbt.func_74775_l(STATE_TAG));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == KEY_RING_INVENTORY_CAPABILITY || capability == KEY_RING_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == KEY_RING_INVENTORY_CAPABILITY) {
            return (T)KEY_RING_INVENTORY_CAPABILITY.cast((Object)this.inventory_instance);
        }
        if (capability == KEY_RING_CAPABILITY) {
            return (T)KEY_RING_CAPABILITY.cast((Object)this.instance);
        }
        return null;
    }
}

