/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.chest;

import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.enums.Rotate;
import com.someguyssoftware.treasure2.chest.ILockSlot;
import net.minecraft.nbt.NBTTagCompound;

public class LockSlot
implements ILockSlot {
    private int index;
    private Direction face;
    private float xOffset;
    private float yOffset;
    private float zOffset;
    private float rotation;

    public LockSlot(int index, Direction face, float x, float y, float z, float rotation) {
        this.setIndex(index);
        this.setFace(face);
        this.setXOffset(x);
        this.setYOffset(y);
        this.setZOffset(z);
        this.setRotation(rotation);
    }

    @Override
    public ILockSlot rotate(Rotate r) {
        Direction newFace = this.getFace().rotate(r);
        float x = 0.0f;
        float z = 0.0f;
        float rotation = 0.0f;
        block0 : switch (r) {
            case ROTATE_90: {
                switch (this.getFace()) {
                    case NORTH: {
                        x = 1.0f - this.getZOffset();
                        z = this.getXOffset();
                        rotation = 90.0f;
                        break block0;
                    }
                    case EAST: {
                        x = this.getZOffset();
                        z = this.getXOffset();
                        rotation = 180.0f;
                        break block0;
                    }
                    case SOUTH: {
                        x = 1.0f - this.getZOffset();
                        z = this.getXOffset();
                        rotation = -90.0f;
                        break block0;
                    }
                    case WEST: {
                        x = this.getZOffset();
                        z = this.getXOffset();
                        rotation = 0.0f;
                        break block0;
                    }
                }
                break;
            }
            case ROTATE_180: {
                switch (this.getFace()) {
                    case NORTH: {
                        x = 1.0f - this.getXOffset();
                        z = 1.0f - this.getZOffset();
                        rotation = 180.0f;
                    }
                    case SOUTH: {
                        x = 1.0f - this.getXOffset();
                        z = 1.0f - this.getZOffset();
                        rotation = 180.0f;
                        break block0;
                    }
                    case EAST: {
                        x = 1.0f - this.getXOffset();
                        z = this.getZOffset();
                        rotation = -90.0f;
                    }
                    case WEST: {
                        x = 1.0f - this.getXOffset();
                        z = this.getZOffset();
                        rotation = 90.0f;
                        break block0;
                    }
                }
                break;
            }
            case ROTATE_270: {
                switch (this.getFace()) {
                    case NORTH: {
                        x = this.getZOffset();
                        z = 1.0f - this.getXOffset();
                        rotation = -90.0f;
                        break block0;
                    }
                    case EAST: {
                        x = this.getZOffset();
                        z = 1.0f - this.getXOffset();
                        rotation = 0.0f;
                        break block0;
                    }
                    case SOUTH: {
                        x = this.getZOffset();
                        z = 1.0f - this.getXOffset();
                        rotation = 90.0f;
                        break block0;
                    }
                    case WEST: {
                        x = this.getZOffset();
                        z = 1.0f - this.getXOffset();
                        rotation = 180.0f;
                        break block0;
                    }
                }
                break;
            }
        }
        LockSlot slot = new LockSlot(this.getIndex(), newFace, x, this.getYOffset(), z, rotation);
        return slot;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        try {
            nbt.func_74768_a("index", this.getIndex());
            nbt.func_74768_a("face", this.getFace().getCode().intValue());
            nbt.func_74776_a("x", this.getXOffset());
            nbt.func_74776_a("y", this.getYOffset());
            nbt.func_74776_a("z", this.getZOffset());
            nbt.func_74776_a("rotation", this.getRotation());
        }
        catch (Exception e) {
            GottschCore.logger.error("Unable to write state to NBT:", (Throwable)e);
        }
        return nbt;
    }

    @Override
    public Direction getFace() {
        return this.face;
    }

    @Override
    public void setFace(Direction face) {
        this.face = face;
    }

    @Override
    public float getXOffset() {
        return this.xOffset;
    }

    @Override
    public void setXOffset(float xOffset) {
        this.xOffset = xOffset;
    }

    @Override
    public float getYOffset() {
        return this.yOffset;
    }

    @Override
    public void setYOffset(float yOffset) {
        this.yOffset = yOffset;
    }

    @Override
    public float getZOffset() {
        return this.zOffset;
    }

    @Override
    public void setZOffset(float zOffset) {
        this.zOffset = zOffset;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public String toString() {
        return "LockSlot [index=" + this.index + ", face=" + this.face + ", xOffset=" + this.xOffset + ", yOffset=" + this.yOffset + ", zOffset=" + this.zOffset + ", rotation=" + this.rotation + "]";
    }
}

