/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.command;

import com.someguyssoftware.gottschcore.loot.LootTable;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.cli.CommandLine;
import com.someguyssoftware.treasure2.cli.DefaultParser;
import com.someguyssoftware.treasure2.cli.Options;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.enums.WorldGenerators;
import com.someguyssoftware.treasure2.generator.chest.IChestGenerator;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import com.someguyssoftware.treasure2.worldgen.SurfaceChestWorldGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnChestCommand
extends CommandBase {
    private static final String RARITY_ARG = "rarity";

    public String func_71517_b() {
        return "t2-chest";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/t2-chest <x> <y> <z> [-rarity <rarity>]: generates a Treasure! chest at location (x,y,z)";
    }

    public int func_82362_a() {
        return 2;
    }

    private int getOriginValue(ICommandSender commandSender, char coordName) {
        switch (coordName) {
            case 'z': {
                return commandSender.func_180425_c().func_177952_p();
            }
            case 'y': {
                return commandSender.func_180425_c().func_177956_o();
            }
        }
        return commandSender.func_180425_c().func_177958_n();
    }

    private int getPositionValue(String coordStr, ICommandSender commandSender, char coordName) {
        int value = 0;
        int origin = 0;
        if (coordStr.equals("~")) {
            origin = this.getOriginValue(commandSender, coordName);
        } else if (coordStr.charAt(0) == '~') {
            try {
                value = Integer.parseInt(coordStr.substring(1));
            }
            catch (Exception e) {
                Treasure.logger.error("Error with " + coordName + " coordinate: ", (Throwable)e);
                value = 0;
            }
            origin = this.getOriginValue(commandSender, coordName);
        } else {
            try {
                value = Integer.parseInt(coordStr);
            }
            catch (Exception e) {
                Treasure.logger.error("Error with " + coordName + " coordinate: ", (Throwable)e);
                value = 0;
            }
        }
        return value + origin;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) {
        Treasure.logger.debug("Starting to spawn Treasure! chest ...");
        try {
            int z = 0;
            int x = this.getPositionValue(args[0], commandSender, 'x');
            int y = this.getPositionValue(args[1], commandSender, 'y');
            z = this.getPositionValue(args[2], commandSender, 'z');
            String[] parserArgs = Arrays.copyOfRange(args, 3, args.length);
            DefaultParser parser = new DefaultParser();
            Options options = new Options();
            options.addOption(RARITY_ARG, true, "");
            CommandLine line = parser.parse(options, parserArgs);
            Rarity rarity = Rarity.COMMON;
            if (line.hasOption(RARITY_ARG)) {
                String rarityArg = line.getOptionValue(RARITY_ARG);
                rarity = Rarity.valueOf(rarityArg.toUpperCase());
            }
            Treasure.logger.debug("Rarity:" + (Object)((Object)rarity) + "; " + rarity.ordinal());
            World world = commandSender.func_130014_f_();
            Random random = new Random();
            SurfaceChestWorldGenerator chestGens = (SurfaceChestWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.SURFACE_CHEST);
            IChestGenerator gen = (IChestGenerator)chestGens.getChestGenMap().get((Object)rarity).next();
            BlockPos pos = new BlockPos(x, y, z);
            AbstractChestBlock chest = gen.selectChest(random, rarity);
            world.func_175656_a(pos, chest.func_176223_P());
            AbstractTreasureChestTileEntity tileEntity = (AbstractTreasureChestTileEntity)world.func_175625_s(pos);
            if (tileEntity != null) {
                LootTable lootTable = gen.selectLootTable(new Random(), rarity);
                if (lootTable == null) {
                    Treasure.logger.warn("Unable to select a lootTable for rarity -> {}", (Object)rarity);
                }
                Treasure.logger.debug("Generating loot from loot table for rarity {}", (Object)rarity);
                List stacks = lootTable.generateLootFromPools(new Random(), Treasure.LOOT_TABLES.getContext());
                Treasure.logger.debug("Generated loot:");
                for (ItemStack stack : stacks) {
                    Treasure.logger.debug(stack.func_82833_r());
                }
                lootTable.fillInventory((IInventory)tileEntity, new Random(), Treasure.LOOT_TABLES.getContext());
            }
        }
        catch (Exception e) {
            Treasure.logger.error("Error generating Treasure! chest: ", (Throwable)e);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length > 3 && args[args.length - 2].equals("-rarity")) {
            return SpawnChestCommand.func_175762_a((String[])args, Rarity.getNames());
        }
        return Collections.emptyList();
    }
}

