/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.eventhandler;

import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.FogBlock;
import com.someguyssoftware.treasure2.capability.CharmCapabilityProvider;
import com.someguyssoftware.treasure2.capability.ICharmCapability;
import com.someguyssoftware.treasure2.capability.PouchCapabilityProvider;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.FogType;
import com.someguyssoftware.treasure2.item.IPouch;
import com.someguyssoftware.treasure2.item.PouchType;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.item.charm.ICharmState;
import com.someguyssoftware.treasure2.network.CharmMessageToClient;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;

public class PlayerEventHandler {
    private static final String FIRST_JOIN_NBT_KEY = "treasure2.firstjoin";
    private static final String PATCHOULI_MODID = "patchouli";
    private static final String PATCHOULI_GUIDE_BOOK_ID = "patchouli:guide_book";
    private static final String PATCHOULI_GUIDE_TAG_ID = "patchouli:book";
    private static final String TREASURE2_GUIDE_TAG_VALUE = "treasure2:guide";
    private IMod mod;

    public PlayerEventHandler(IMod mod) {
        this.setMod(mod);
    }

    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        NBTTagCompound persistent;
        if (!TreasureConfig.MOD.enableStartingBook) {
            return;
        }
        if (event.player.func_184812_l_()) {
            return;
        }
        NBTTagCompound data = event.player.getEntityData();
        if (!data.func_74764_b("PlayerPersisted")) {
            persistent = new NBTTagCompound();
            data.func_74782_a("PlayerPersisted", (NBTBase)persistent);
        } else {
            persistent = data.func_74775_l("PlayerPersisted");
        }
        if (Loader.isModLoaded((String)PATCHOULI_MODID) && !persistent.func_74764_b(FIRST_JOIN_NBT_KEY)) {
            persistent.func_74757_a(FIRST_JOIN_NBT_KEY, true);
            Item guideBook = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(PATCHOULI_GUIDE_BOOK_ID));
            ItemStack stack = new ItemStack(guideBook);
            if (!stack.func_77942_o()) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a(PATCHOULI_GUIDE_TAG_ID, TREASURE2_GUIDE_TAG_VALUE);
                stack.func_77982_d(tag);
            }
            event.player.field_71071_by.func_70441_a(stack);
        }
    }

    @SubscribeEvent
    public void checkFogInteraction(LivingEvent.LivingUpdateEvent event) {
        if (WorldInfo.isClientSide((World)event.getEntity().func_130014_f_())) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            BlockPos pos = player.func_180425_c();
            Block block = event.getEntity().func_130014_f_().func_180495_p(pos).func_177230_c();
            if (block instanceof FogBlock) {
                PotionEffect potionEffect;
                if (((FogBlock)block).getFogType() == FogType.WITHER) {
                    PotionEffect potionEffect2 = ((EntityLivingBase)event.getEntity()).func_70660_b(MobEffects.field_82731_v);
                    if (potionEffect2 == null) {
                        ((EntityLivingBase)event.getEntity()).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 300, 0));
                    }
                } else if (((FogBlock)block).getFogType() == FogType.POISON && (potionEffect = ((EntityLivingBase)event.getEntity()).func_70660_b(MobEffects.field_76436_u)) == null) {
                    ((EntityLivingBase)event.getEntity()).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 300, 0));
                }
            }
        }
    }

    @SubscribeEvent
    public void checkCharmsInteraction(LivingEvent.LivingUpdateEvent event) {
        if (WorldInfo.isClientSide((World)event.getEntity().func_130014_f_())) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            this.processCharms((Event)event, player);
        }
    }

    @SubscribeEvent
    public void checkCharmsInteractionWithDamage(LivingDamageEvent event) {
        if (WorldInfo.isClientSide((World)event.getEntity().func_130014_f_())) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            this.processCharms((Event)event, player);
        }
    }

    @SubscribeEvent
    public void checkCharmsInteractionWithBlock(BlockEvent.HarvestDropsEvent event) {
        if (WorldInfo.isClientSide((World)event.getWorld())) {
            return;
        }
        if (event.getHarvester() == null) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getHarvester();
        this.processCharms((Event)event, player);
    }

    private void processCharms(Event event, EntityPlayerMP player) {
        Optional<CharmContext> context = this.getCharmContext(player);
        if (!context.isPresent()) {
            return;
        }
        if (context.get().type == CharmedType.FOCUS) {
            IItemHandler cap = (IItemHandler)context.get().itemStack.getCapability(PouchCapabilityProvider.INVENTORY_CAPABILITY, null);
            int slots = context.get().itemStack.func_77973_b() == TreasureItems.LUCKY_POUCH ? 1 : (context.get().itemStack.func_77973_b() == TreasureItems.APPRENTICES_POUCH ? 2 : 3);
            for (int focusIndex = 0; focusIndex < slots; ++focusIndex) {
                ItemStack itemStack = cap.getStackInSlot(focusIndex);
                if (!itemStack.hasCapability(CharmCapabilityProvider.CHARM_CAPABILITY, null)) continue;
                context.get().itemStack = itemStack;
                context.get().slot = focusIndex;
                this.doCharms(context, player, event);
            }
        } else {
            this.doCharms(context, player, event);
        }
    }

    private void doCharms(Optional<CharmContext> context, EntityPlayerMP player, Event event) {
        ICharmCapability capability = (ICharmCapability)context.get().itemStack.getCapability(CharmCapabilityProvider.CHARM_CAPABILITY, null);
        List<ICharmState> charmStates = capability.getCharmStates();
        for (ICharmState charmState : charmStates) {
            if (!charmState.doCharm(player.field_70170_p, new Random(), (ICoords)new Coords((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v), (EntityPlayer)player, event)) continue;
            CharmMessageToClient message = new CharmMessageToClient(player.func_70005_c_(), charmState, context.get().hand, null);
            Treasure.simpleNetworkWrapper.sendTo((IMessage)message, player);
        }
    }

    private Optional<CharmContext> getCharmContext(EntityPlayerMP player) {
        CharmContext context = new CharmContext();
        ItemStack offHeldStack = player.func_184586_b(EnumHand.OFF_HAND);
        context.hand = EnumHand.OFF_HAND;
        context.itemStack = offHeldStack;
        if (offHeldStack.hasCapability(CharmCapabilityProvider.CHARM_CAPABILITY, null)) {
            context.type = CharmedType.CHARM;
        } else if (offHeldStack.func_77973_b() instanceof IPouch && ((IPouch)offHeldStack.func_77973_b()).getPouchType() == PouchType.ARCANE) {
            context.type = CharmedType.FOCUS;
        } else {
            ItemStack mainHeldStack = player.func_184586_b(EnumHand.MAIN_HAND);
            context.hand = EnumHand.MAIN_HAND;
            context.itemStack = mainHeldStack;
            if (mainHeldStack.hasCapability(CharmCapabilityProvider.CHARM_CAPABILITY, null)) {
                context.type = CharmedType.CHARM;
            } else if (mainHeldStack.func_77973_b() instanceof IPouch && ((IPouch)mainHeldStack.func_77973_b()).getPouchType() == PouchType.ARCANE) {
                context.type = CharmedType.FOCUS;
            } else {
                return Optional.empty();
            }
        }
        return Optional.of(context);
    }

    public IMod getMod() {
        return this.mod;
    }

    public void setMod(IMod mod) {
        this.mod = mod;
    }

    private static enum CharmedType {
        CHARM,
        FOCUS;

    }

    private class CharmContext {
        EnumHand hand;
        Integer slot;
        ItemStack itemStack;
        CharmedType type;

        CharmContext() {
        }

        CharmContext(ItemStack stack, EnumHand hand, Integer slot, CharmedType type) {
            this.itemStack = stack;
            this.hand = hand;
            this.slot = slot;
            this.type = type;
        }
    }
}

