/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator;

import com.someguyssoftware.gottschcore.block.AbstractModContainerBlock;
import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.gottschcore.world.gen.structure.StructureMarkers;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.block.FogBlock;
import com.someguyssoftware.treasure2.block.ITreasureBlock;
import com.someguyssoftware.treasure2.block.SkeletonBlock;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.chest.ChestInfo;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.registry.ChestRegistry;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GenUtil {
    public static final PropertyEnum<EnumFacing> FACING = PropertyDirection.func_177709_a((String)"facing", EnumFacing.class);
    protected static final int UNDERGROUND_OFFSET = 5;
    protected static final int VERTICAL_MAX_DIFF = 2;
    private static final int FOG_RADIUS = 5;

    public static Block getMarkerBlock(StructureMarkers marker) {
        return (Block)Treasure.TEMPLATE_MANAGER.getMarkerMap().get(marker);
    }

    public static AbstractTreasureChestTileEntity getChestTileEntity(World world, ICoords coords) {
        BlockPos pos = coords.toPos();
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            Treasure.logger.warn("Unable to locate ChestConfig TileEntity @: " + pos);
            return null;
        }
        if (!(te instanceof AbstractTreasureChestTileEntity)) {
            Treasure.logger.warn("ChestConfig TileEntity does not implement TreasureChestTileEntity @: " + pos);
            return null;
        }
        return (AbstractTreasureChestTileEntity)te;
    }

    public static boolean replaceWithBlock(World world, ICoords coords, Block block) {
        Cube cube = new Cube(world, coords);
        if (cube.isAir()) {
            return false;
        }
        world.func_175656_a(coords.toPos(), block.func_176223_P());
        return true;
    }

    public static boolean replaceWithBlockState(World world, ICoords coords, IBlockState blockState) {
        Cube cube = new Cube(world, coords);
        if (cube.isAir()) {
            return false;
        }
        world.func_175656_a(coords.toPos(), blockState);
        return true;
    }

    public static boolean replaceBlockWithChest(World world, Random random, Block chest, ICoords coords) {
        IBlockState oldState = world.func_180495_p(coords.toPos());
        if (oldState.func_177228_b().containsKey(FACING)) {
            Treasure.logger.debug("World Chest marker has FACING property:" + oldState.func_177229_b(FACING));
            return GenUtil.placeChest(world, chest, coords, (EnumFacing)oldState.func_177229_b(FACING));
        }
        Treasure.logger.debug("World Chest marker does NOT have a FACING property.");
        return GenUtil.placeChest(world, chest, coords, EnumFacing.field_176754_o[random.nextInt(EnumFacing.field_176754_o.length)]);
    }

    public static boolean replaceBlockWithChest(World world, Random random, ICoords coords, Block chest, IBlockState state) {
        if (state.func_177228_b().containsKey(FACING)) {
            Treasure.logger.debug("Given marker state has FACING property -> {}", (Object)state.func_177229_b(FACING));
            return GenUtil.placeChest(world, chest, coords, (EnumFacing)state.func_177229_b(FACING));
        }
        if (state.func_177230_c() == Blocks.field_150486_ae) {
            Treasure.logger.debug("Given marker state is a vanilla chest.");
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockChest.field_176459_a);
            return GenUtil.placeChest(world, chest, coords, facing);
        }
        Treasure.logger.debug("Given marker state neither has FACING nor is a vanilla chest.");
        return GenUtil.replaceBlockWithChest(world, random, chest, coords);
    }

    public static boolean placeChest(World world, Block chest, ICoords coords, EnumFacing facing) {
        if (!WorldInfo.isValidY((ICoords)coords)) {
            Treasure.logger.debug("Cannot place chest due to invalid y pos -> {}", (Object)coords.toShortString());
            return false;
        }
        try {
            BlockPos pos = coords.toPos();
            world.func_180501_a(pos, chest.func_176223_P().func_177226_a(FACING, (Comparable)facing), 3);
            Treasure.logger.debug("placed chest -> {} into world at coords -> {} with prop -> {}", (Object)chest.getClass().getSimpleName(), (Object)coords.toShortString(), (Object)facing);
            Direction direction = Direction.fromFacing((EnumFacing)facing);
            ((AbstractChestBlock)chest).rotateLockStates(world, pos, Direction.NORTH.getRotation(direction));
            TileEntity te = world.func_175625_s(pos);
            if (te == null) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                Treasure.logger.warn("Unable to create ChestConfig's TileEntity, removing ChestConfig.");
                return false;
            }
            ((AbstractTreasureChestTileEntity)te).setFacing(facing.func_176745_a());
        }
        catch (Exception e) {
            Treasure.logger.error("An error occurred placing chest: ", (Throwable)e);
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean placeMarkers(World world, Random random, ICoords coords) {
        boolean isSuccess = false;
        Treasure.logger.debug("Using coords {} to seed markers.", (Object)coords.toShortString());
        if (!TreasureConfig.WORLD_GEN.getMarkerProperties().isGravestonesAllowed) {
            return false;
        }
        int x = coords.getX();
        int z = coords.getZ();
        int numberOfMarkers = RandomHelper.randomInt((int)TreasureConfig.WORLD_GEN.getMarkerProperties().minGravestonesPerChest, (int)TreasureConfig.WORLD_GEN.getMarkerProperties().maxGravestonesPerChest);
        int gridSize = 4;
        if (numberOfMarkers >= 6) {
            gridSize = numberOfMarkers >= 6 && numberOfMarkers <= 8 ? 5 : 6;
        }
        for (int i = 0; i < numberOfMarkers; ++i) {
            int zSpawn;
            int ySpawn;
            int xSpawn = x + random.nextInt(gridSize) * (random.nextInt(3) - 1);
            Coords spawnCoords = new Coords(xSpawn, ySpawn = WorldInfo.getHeightValue((World)world, (ICoords)new Coords(xSpawn, 0, zSpawn = z + random.nextInt(gridSize) * (random.nextInt(3) - 1))), zSpawn);
            if (!WorldInfo.isValidY((ICoords)spawnCoords)) {
                Treasure.logger.debug(String.format("[%d] is not a valid y value.", spawnCoords.getY()));
                continue;
            }
            if ((spawnCoords = WorldInfo.getDryLandSurfaceCoords((World)world, (ICoords)spawnCoords)) == null) {
                Treasure.logger.debug(String.format("Not a valid surface @ %s", coords));
                continue;
            }
            Cube cube = new Cube(world, (ICoords)spawnCoords);
            if (!(cube.isAir() || cube.isReplaceable() || cube.equalsMaterial(TreasureItems.FOG))) {
                Treasure.logger.debug("Marker not placed because block  @ [{}] is not Air, Replaceable nor Fog.", (Object)spawnCoords.toShortString());
                continue;
            }
            Block block = world.func_180495_p(spawnCoords.add(0, -1, 0).toPos()).func_177230_c();
            if (block instanceof BlockContainer || block instanceof AbstractModContainerBlock || block instanceof ITreasureBlock) {
                Treasure.logger.debug("Marker not placed because block underneath is a chest, container or Treasure block.");
                continue;
            }
            Block marker = null;
            marker = TreasureBlocks.gravestones.get(random.nextInt(TreasureBlocks.gravestones.size()));
            EnumFacing[] horizontals = EnumFacing.field_176754_o;
            EnumFacing facing = horizontals[random.nextInt(horizontals.length)];
            world.func_175656_a(spawnCoords.toPos(), marker.func_176223_P().func_177226_a(AbstractChestBlock.FACING, (Comparable)facing));
            if (TreasureConfig.WORLD_GEN.getGeneralProperties().enableFog && RandomHelper.checkProbability((Random)random, (int)TreasureConfig.WORLD_GEN.getMarkerProperties().gravestoneFogProbability)) {
                ArrayList fogDensity = new ArrayList(5);
                int fogSize = RandomHelper.randomInt((int)1, (int)4);
                GenUtil.addFog(world, random, (ICoords)spawnCoords, fogDensity.toArray(new FogBlock[0]));
            }
            isSuccess = true;
        }
        return isSuccess;
    }

    public static void placeSkeleton(World world, Random random, ICoords coords) {
        boolean flag3;
        EnumFacing[] horizontals = EnumFacing.field_176754_o;
        EnumFacing facing = horizontals[random.nextInt(horizontals.length)];
        Coords coords2 = new Coords(coords.toPos().func_177972_a(facing));
        Cube cube = new Cube(world, coords);
        Cube cube2 = new Cube(world, (ICoords)coords2);
        boolean flag = cube.isReplaceable();
        boolean flag1 = cube2.isReplaceable();
        boolean flag2 = flag || cube.isAir();
        boolean bl = flag3 = flag1 || cube2.isAir();
        if (flag2 && flag3 && world.func_180495_p(coords.down(1).toPos()).isSideSolid((IBlockAccess)world, coords.down(1).toPos(), EnumFacing.UP) && world.func_180495_p(coords2.down(1).toPos()).isSideSolid((IBlockAccess)world, coords2.down(1).toPos(), EnumFacing.UP)) {
            IBlockState skeletonState = TreasureBlocks.SKELETON.func_176223_P().func_177226_a((IProperty)SkeletonBlock.FACING, (Comparable)facing.func_176734_d()).func_177226_a(SkeletonBlock.PART, (Comparable)((Object)SkeletonBlock.EnumPartType.BOTTOM));
            world.func_180501_a(coords.toPos(), skeletonState, 3);
            world.func_180501_a(coords2.toPos(), skeletonState.func_177226_a(SkeletonBlock.PART, (Comparable)((Object)SkeletonBlock.EnumPartType.TOP)), 3);
            world.func_175722_b(coords.toPos(), cube.getState().func_177230_c(), false);
            world.func_175722_b(coords2.toPos(), cube.getState().func_177230_c(), false);
        }
    }

    public static void addFog(World world, Random random, ICoords coords, FogBlock[] fogDensity) {
        ICoords fogCoords = null;
        for (int xOffset = -5; xOffset <= 5; ++xOffset) {
            for (int zOffset = -5; zOffset <= 5; ++zOffset) {
                FogBlock origBlock;
                Cube cube;
                int radius = Math.abs(xOffset) + Math.abs(zOffset);
                if (radius > 5 || xOffset == 0 && zOffset == 0) continue;
                int yHeight = WorldInfo.getHeightValue((World)world, (ICoords)coords.add(xOffset, 255, zOffset));
                fogCoords = WorldInfo.getDryLandSurfaceCoords((World)world, (ICoords)new Coords(coords.getX() + xOffset, yHeight, coords.getZ() + zOffset));
                if (world.func_180495_p(fogCoords.down(1).toPos()).func_177230_c() instanceof ITreasureBlock) continue;
                ICoords deltaCoords = fogCoords.delta(coords);
                FogBlock block = null;
                if (Math.abs(deltaCoords.getY()) > 2 || !(cube = new Cube(world, fogCoords)).isAir() && !cube.isReplaceable() && !cube.equalsMaterial(TreasureItems.FOG)) continue;
                if (radius > fogDensity.length) {
                    radius = fogDensity.length;
                }
                if (radius < 1) {
                    radius = 1;
                }
                block = fogDensity[radius - 1];
                if (cube.equalsMaterial(TreasureItems.FOG) && (origBlock = (FogBlock)cube.getState().func_177230_c()).getFogHeight().getSize() > block.getFogHeight().getSize()) continue;
                world.func_175656_a(fogCoords.toPos(), block.func_176223_P());
            }
        }
    }

    public static ICoords getUndergroundSpawnCoords(World world, Random random, ICoords surfaceCoords, int spawnYMin) {
        Coords spawnCoords = null;
        if (surfaceCoords.getY() > spawnYMin + 5) {
            int ySpawn = random.nextInt(surfaceCoords.getY() - (spawnYMin + 5)) + spawnYMin;
            spawnCoords = new Coords(surfaceCoords.getX(), ySpawn, surfaceCoords.getZ());
            spawnCoords = WorldInfo.getDryLandSurfaceCoords((World)world, (ICoords)spawnCoords);
        }
        return spawnCoords;
    }

    public static ICoords findUndergroundCeiling(World world, ICoords coords) {
        int CEILING_FAIL_SAFE = 50;
        int ceilingHeight = 1;
        while (world.func_175623_d(coords.toPos())) {
            if (++ceilingHeight > world.func_72800_K() || ceilingHeight == 50) {
                return null;
            }
            coords = coords.add(0, 1, 0);
        }
        coords = coords.add(0, 1, 0);
        return coords;
    }

    @Deprecated
    public static void fillSimpleShaftRandomly(World world, Random random, ICoords coords, ICoords surfaceCoords) {
        for (int i = coords.getY() + 4; i <= surfaceCoords.getY() - 5; ++i) {
            Coords replaceCoords = new Coords(coords.getX(), i, coords.getZ());
            if (world.func_175623_d(replaceCoords.toPos())) continue;
            IBlockState blockState = null;
            int m = random.nextInt(100);
            if (m < 50) {
                blockState = Blocks.field_150350_a.func_176223_P();
            } else if (m < 75) {
                blockState = Blocks.field_150354_m.func_176223_P();
            } else if (m < 90) {
                blockState = Blocks.field_150351_n.func_176223_P();
            } else if (m < 100) {
                blockState = Blocks.field_150364_r.func_176223_P();
            }
            world.func_180501_a(replaceCoords.toPos(), blockState, 3);
        }
    }

    public static void fillSimpleShaftWithAir(World world, ICoords coords, ICoords surfaceCoords) {
        int ABOVE_CHEST_SIZE = 3;
        int BELOW_SURFACE_SIZE = 5;
        for (int i = coords.getY() + 4; i <= surfaceCoords.getY() - 5; ++i) {
            world.func_180501_a(new BlockPos(coords.getX(), i, coords.getZ()), Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public static boolean isRegisteredChestWithinDistance(World world, ICoords coords, int minDistance) {
        double minDistanceSq = minDistance * minDistance;
        List<ChestInfo> infos = ChestRegistry.getInstance().getValues();
        if (infos == null || infos.size() == 0) {
            Treasure.logger.debug("Unable to locate the ChestConfig Registry or the Registry doesn't contain any values");
            return false;
        }
        Treasure.logger.debug("Min distance Sq -> {}", (Object)minDistanceSq);
        for (ChestInfo info : infos) {
            double distance = coords.getDistanceSq(info.getCoords());
            Treasure.logger.debug("ChestConfig dist^2: " + distance);
            if (!(distance < minDistanceSq)) continue;
            return true;
        }
        return false;
    }
}

