/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.oasis;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.chest.ChestInfo;
import com.someguyssoftware.treasure2.config.IOasisConfig;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.enums.WorldGenerators;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.TemplateGeneratorData;
import com.someguyssoftware.treasure2.generator.chest.IChestGenerator;
import com.someguyssoftware.treasure2.generator.oasis.IOasisGenerator;
import com.someguyssoftware.treasure2.generator.well.WellGenerator;
import com.someguyssoftware.treasure2.meta.StructureArchetype;
import com.someguyssoftware.treasure2.meta.StructureType;
import com.someguyssoftware.treasure2.registry.ChestRegistry;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import com.someguyssoftware.treasure2.worldgen.SurfaceChestWorldGenerator;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenerator;

public class DesertOasisGenerator
implements IOasisGenerator<GeneratorResult<ChestGeneratorData>> {
    private static final int MIN_OASIS_RADIUS = 8;
    private static final int MAX_OASIS_RADIUS = 20;

    @Override
    public GeneratorResult<GeneratorData> generate(World world, Random random, ICoords coords) {
        Coords chestCoords = null;
        GeneratorResult<GeneratorData> result = new GeneratorResult<GeneratorData>(GeneratorData.class);
        ICoords surfaceCoords = WorldInfo.getDryLandSurfaceCoords((World)world, (ICoords)coords);
        Treasure.logger.debug("surface coords -> {}", (Object)surfaceCoords.toShortString());
        if (!WorldInfo.isValidY((ICoords)surfaceCoords)) {
            Treasure.logger.debug("surface coords are invalid @ {}", (Object)surfaceCoords.toShortString());
            return result.fail();
        }
        int radius = RandomHelper.randomInt((Random)random, (int)8, (int)20);
        AxisAlignedBB oasisBounds = new AxisAlignedBB(coords.add(-radius, 0, -radius).toPos(), coords.add(radius, 0, radius).toPos());
        int width = Math.abs((int)(oasisBounds.field_72336_d - oasisBounds.field_72340_a));
        int depth = Math.abs((int)(oasisBounds.field_72334_f - oasisBounds.field_72339_c));
        Coords centerCoords = new Coords((int)(oasisBounds.field_72340_a + (double)width * 0.5), (int)oasisBounds.field_72338_b, (int)(oasisBounds.field_72339_c + (double)depth * 0.5));
        centerCoords = WorldInfo.getDryLandSurfaceCoords((World)world, (ICoords)centerCoords);
        this.generateBase(world, random, coords, radius);
        this.generateTrees(world, random, (ICoords)centerCoords, radius);
        this.generateGrass(world, random, (ICoords)centerCoords, radius);
        this.generateFlowers(world, random, (ICoords)centerCoords, radius);
        Optional<GeneratorResult<GeneratorData>> wellResult = Optional.ofNullable(this.generateWell(world, random, (ICoords)centerCoords));
        if (wellResult.isPresent() && wellResult.get().isSuccess()) {
            TemplateGeneratorData data = (TemplateGeneratorData)wellResult.get().getData();
            ICoords wellSpawnCoords = data.getSpawnCoords();
            ICoords wellSize = data.getSize();
            chestCoords = wellSpawnCoords.add(wellSize.getX(), 0, wellSize.getZ() / 2);
            wellResult.get().getData().setSpawnCoords((ICoords)centerCoords);
        } else {
            chestCoords = centerCoords;
        }
        this.generateChest(world, random, (ICoords)chestCoords);
        Treasure.logger.info("CHEATER! Desert oasis at coords: {}", (Object)centerCoords.toShortString());
        return wellResult.get();
    }

    private GeneratorResult<GeneratorData> generateWell(World world, Random random, ICoords centerCoords) {
        WellGenerator wellGenerator = new WellGenerator();
        TemplateHolder templateHolder = Treasure.TEMPLATE_MANAGER.getTemplate(world, random, StructureArchetype.SURFACE, StructureType.WELL, Biomes.field_76767_f);
        GeneratorResult result = (GeneratorResult)wellGenerator.generate(world, random, centerCoords, templateHolder, TreasureConfig.WELL);
        return result;
    }

    private GeneratorResult<ChestGeneratorData> generateChest(World world, Random random, ICoords chestCoords) {
        Rarity rarity = Rarity.values()[random.nextInt(Rarity.values().length)];
        IBlockState chestState = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.field_176754_o[random.nextInt(EnumFacing.field_176754_o.length)]);
        SurfaceChestWorldGenerator chestWorldGen = (SurfaceChestWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.SURFACE_CHEST);
        IChestGenerator chestGen = (IChestGenerator)chestWorldGen.getChestGenMap().get((Object)rarity).next();
        Optional<GeneratorResult<ChestGeneratorData>> result = Optional.ofNullable(chestGen.generate(world, random, chestCoords, rarity, chestState));
        if (result.isPresent() && result.get().isSuccess()) {
            ChestRegistry.getInstance().register(chestCoords.toShortString(), new ChestInfo(rarity, chestCoords));
        }
        return result.get();
    }

    private void generateBase(World world, Random random, ICoords coords, int radius) {
        int radiusSquared = radius * radius;
        Integer[] distancesMet = new Integer[radius + 1];
        ICoords spawnCoords = null;
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                boolean isDistanceMet = false;
                spawnCoords = coords.add(xOffset, 0, zOffset);
                if (distancesMet[Math.abs(xOffset)] != null) {
                    if (Math.abs(zOffset) <= distancesMet[Math.abs(xOffset)]) {
                        isDistanceMet = true;
                    }
                } else if (coords.getDistanceSq(spawnCoords) < (double)radiusSquared) {
                    distancesMet[Math.abs((int)xOffset)] = Math.abs(zOffset);
                    isDistanceMet = true;
                }
                if (!isDistanceMet) continue;
                spawnCoords = WorldInfo.getDryLandSurfaceCoords((World)world, (ICoords)spawnCoords.withY(255));
                for (int i = 0; i < 3; ++i) {
                    Cube grassCube = new Cube(world, spawnCoords);
                    Cube sandCube = new Cube(world, (spawnCoords = spawnCoords.down(1)).down(1));
                    if (!sandCube.equalsBlock((Block)Blocks.field_150354_m) && (i <= 0 || !grassCube.equalsBlock((Block)Blocks.field_150349_c))) continue;
                    world.func_180501_a(spawnCoords.toPos(), Blocks.field_150349_c.func_176223_P(), 3);
                }
            }
        }
    }

    private void generateTrees(World world, Random random, ICoords centerCoords, int radius) {
        WorldGenAbstractTree treeWorldGenerator = Biomes.field_76767_f.func_150567_a(random);
        int diameter = radius * 2;
        int diameterSquared = diameter * diameter;
        int numberOfTrees = (int)((double)(diameterSquared / 256) * (double)this.getConfig().getTreesPerChunk() * this.getConfig().getTreesPerChunkSizeFactor());
        for (int treeIndex = 0; treeIndex < numberOfTrees; ++treeIndex) {
            int xOffset = (int)(random.nextFloat() * (float)diameter - (float)radius);
            int zOffset = (int)(random.nextFloat() * (float)diameter - (float)radius);
            Treasure.logger.debug("attempting oasis tree @ -> {}", (Object)centerCoords.add(xOffset, 0, zOffset).toShortString());
            boolean treeResult = treeWorldGenerator.func_180709_b(world, random, centerCoords.add(xOffset, 0, zOffset).toPos());
            Treasure.logger.debug("tree result -> {}", (Object)treeResult);
        }
    }

    private void generateGrass(World world, Random random, ICoords centerCoords, int radius) {
        WorldGenerator grassWorldGenerator = Biomes.field_76767_f.func_76730_b(random);
        int diameter = radius * 2;
        for (int grassIndex = 0; grassIndex < 5; ++grassIndex) {
            int xOffset = (int)(random.nextFloat() * (float)diameter - (float)radius);
            int zOffset = (int)(random.nextFloat() * (float)diameter - (float)radius);
            grassWorldGenerator.func_180709_b(world, random, centerCoords.add(xOffset, 0, zOffset).toPos());
        }
    }

    private void generateFlowers(World world, Random random, ICoords centerCoords, int radius) {
        WorldGenFlowers worldGenerator = new WorldGenFlowers(Blocks.field_150327_N, BlockFlower.EnumFlowerType.DANDELION);
        int diameter = radius * 2;
        for (int grassIndex = 0; grassIndex < 3; ++grassIndex) {
            int zOffset;
            int xOffset = (int)(random.nextFloat() * (float)diameter - (float)radius);
            ICoords blockpos1 = centerCoords.add(xOffset, 0, zOffset = (int)(random.nextFloat() * (float)diameter - (float)radius));
            BlockFlower.EnumFlowerType blockflower$enumflowertype = Biomes.field_76767_f.func_180623_a(random, blockpos1.toPos());
            BlockFlower blockflower = blockflower$enumflowertype.func_176964_a().func_180346_a();
            if (blockflower.func_176223_P().func_185904_a() == Material.field_151579_a) continue;
            worldGenerator.func_175914_a(blockflower, blockflower$enumflowertype);
            worldGenerator.func_180709_b(world, random, blockpos1.toPos());
        }
    }

    @Override
    public IOasisConfig getConfig() {
        return TreasureConfig.OASES.desertOasisProperties;
    }
}

