/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.pit;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.random.RandomWeightedCollection;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.pit.AbstractPitGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class LavaSideTrapPitGenerator
extends AbstractPitGenerator {
    public LavaSideTrapPitGenerator() {
        this.getBlockLayers().add(50, (Object)Blocks.field_150350_a);
        this.getBlockLayers().add(25, (Object)Blocks.field_150354_m);
        this.getBlockLayers().add(15, (Object)Blocks.field_150351_n);
        this.getBlockLayers().add(10, (Object)Blocks.field_150364_r);
    }

    @Override
    public GeneratorResult<ChestGeneratorData> generate(World world, Random random, ICoords surfaceCoords, ICoords spawnCoords) {
        GeneratorResult<ChestGeneratorData> result = super.generate(world, random, surfaceCoords, spawnCoords);
        if (result.isSuccess()) {
            Treasure.logger.debug("Generated Lave Side Trap Pit at " + spawnCoords.toShortString());
        }
        return result;
    }

    @Override
    public ICoords buildPit(World world, Random random, ICoords coords, ICoords surfaceCoords, RandomWeightedCollection<Block> col) {
        ICoords nextCoords = null;
        ICoords expectedCoords = null;
        for (int yIndex = coords.getY() + 5; yIndex <= surfaceCoords.getY() - 6; ++yIndex) {
            Cube cube = new Cube(world, (ICoords)new Coords(coords.getX(), yIndex, coords.getZ()));
            if (cube.isAir()) continue;
            Block block = (Block)col.next();
            nextCoords = block == Blocks.field_150364_r ? this.buildLogLayer(world, random, cube.getCoords(), block) : this.buildLayer(world, cube.getCoords(), block);
            boolean isLava = RandomHelper.checkProbability((Random)random, (int)30);
            if (isLava) {
                this.buildTrapLayer(world, random, cube.getCoords(), (Block)Blocks.field_150353_l);
            }
            expectedCoords = cube.getCoords().add(0, 1, 0);
            yIndex = this.autoCorrectIndex(yIndex, nextCoords, expectedCoords);
        }
        return nextCoords;
    }

    public ICoords buildTrapLayer(World world, Random random, ICoords coords, Block block) {
        int MAX_REPLACES = 5;
        ICoords[] matrix = new ICoords[]{coords.add(-1, 0, -1), coords.add(0, 0, -1), coords.add(1, 0, -1), coords.add(2, 0, -1), coords.add(-1, 0, 1), coords.add(0, 0, 1), coords.add(1, 0, 1), coords.add(2, 0, 1), coords.add(-1, 0, 0), coords.add(-1, 0, 1), coords.add(-1, 0, 2), coords.add(2, 0, 0), coords.add(2, 0, 1), coords.add(2, 0, 2)};
        for (int i = 0; i < 5; ++i) {
            int x = RandomHelper.randomInt((int)0, (int)(matrix.length - 1));
            GenUtil.replaceWithBlockState(world, matrix[x], block.func_176223_P());
        }
        return coords;
    }
}

