/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.inventory;

import com.someguyssoftware.treasure2.inventory.AbstractChestContainer;
import com.someguyssoftware.treasure2.inventory.ArcanePouchSlot;
import com.someguyssoftware.treasure2.inventory.NoSlot;
import com.someguyssoftware.treasure2.inventory.PouchSlot;
import com.someguyssoftware.treasure2.item.PouchItem;
import com.someguyssoftware.treasure2.item.TreasureItems;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class PouchContainer
extends AbstractChestContainer {
    private ItemStack stack;

    public PouchContainer(InventoryPlayer invPlayer, IInventory inventory, ItemStack stack) {
        super(invPlayer, inventory);
        this.stack = stack;
        this.setHotbarYPos(176);
        this.setPlayerInventoryYPos(118);
        this.setContainerInventoryXPos(8 + this.getSlotXSpacing() * 3);
        this.setContainerInventoryYPos(52);
        this.setContainerInventoryRowCount(3);
        this.setContainerInventoryColumnCount(3);
        this.buildContainer(invPlayer, inventory);
    }

    @Override
    public int getContainerInventorySlotCount() {
        return this.inventory.func_70302_i_();
    }

    @Override
    public void buildHotbar(InventoryPlayer player) {
        for (int x = 0; x < 9; ++x) {
            int slotNumber = x;
            if (slotNumber == player.field_70461_c) {
                this.func_75146_a(new NoSlot((IInventory)player, slotNumber, this.getHotbarXPos() + this.getSlotXSpacing() * x, this.getHotbarYPos()));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)player, slotNumber, this.getHotbarXPos() + this.getSlotXSpacing() * x, this.getHotbarYPos()));
        }
    }

    @Override
    public void buildContainerInventory() {
        int arcaneSlots = 0;
        PouchItem pouchItem = (PouchItem)this.stack.func_77973_b();
        if (pouchItem == TreasureItems.LUCKY_POUCH) {
            arcaneSlots = 1;
        } else if (pouchItem == TreasureItems.APPRENTICES_POUCH) {
            arcaneSlots = 2;
        } else if (pouchItem == TreasureItems.MASTERS_POUCH) {
            arcaneSlots = 3;
        }
        for (int y = 0; y < this.getContainerInventoryRowCount(); ++y) {
            for (int x = 0; x < this.getContainerInventoryColumnCount(); ++x) {
                int slotNumber = y * this.getContainerInventoryColumnCount() + x;
                int xpos = this.getContainerInventoryXPos() + x * this.getSlotXSpacing();
                int ypos = this.getContainerInventoryYPos() + y * this.getSlotYSpacing();
                if (slotNumber < arcaneSlots) {
                    this.func_75146_a(new ArcanePouchSlot(this.inventory, slotNumber, xpos, ypos));
                    continue;
                }
                this.func_75146_a(new PouchSlot(this.inventory, slotNumber, xpos, ypos));
            }
        }
    }
}

