/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.item.KeyItem;
import com.someguyssoftware.treasure2.item.LockItem;
import java.util.List;
import java.util.Random;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ThiefsLockPick
extends KeyItem {
    public ThiefsLockPick(String modID, String name) {
        super(modID, name);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String s1 = I18n.func_74837_a((String)"tooltip.thiefs_lock_pick.specials", (Object[])new Object[]{this.getSuccessProbability(), this.getSuccessProbability() - this.getSuccessProbability() / 4.0, this.getSuccessProbability() / 2.0});
        String s2 = I18n.func_74837_a((String)"tooltip.label.specials", (Object[])new Object[]{TextFormatting.GOLD + s1});
        tooltip.add(s2);
    }

    @Override
    public boolean fitsLock(LockItem lockItem) {
        return lockItem.getRarity() == Rarity.COMMON || lockItem.getRarity() == Rarity.UNCOMMON || lockItem.getRarity() == Rarity.SCARCE;
    }

    @Override
    public boolean unlock(LockItem lockItem) {
        if (lockItem.acceptsKey(this) || this.fitsLock(lockItem)) {
            Treasure.logger.debug("Lock accepts key");
            if (lockItem.getRarity() == Rarity.COMMON) {
                if (RandomHelper.checkProbability((Random)new Random(), (double)this.getSuccessProbability())) {
                    Treasure.logger.debug("Unlock attempt met probability");
                    return true;
                }
            } else if (lockItem.getRarity() == Rarity.UNCOMMON) {
                if (RandomHelper.checkProbability((Random)new Random(), (double)(this.getSuccessProbability() - this.getSuccessProbability() / 4.0))) {
                    Treasure.logger.debug("Unlock attempt met probability");
                    return true;
                }
            } else if (lockItem.getRarity() == Rarity.SCARCE && RandomHelper.checkProbability((Random)new Random(), (double)(this.getSuccessProbability() / 2.0))) {
                Treasure.logger.debug("Unlock attempt met probability");
                return true;
            }
        }
        return false;
    }
}

