/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item.charm;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.item.charm.CharmBuilder;
import com.someguyssoftware.treasure2.item.charm.CharmLevel;
import com.someguyssoftware.treasure2.item.charm.CharmType;
import com.someguyssoftware.treasure2.item.charm.ICharm;
import com.someguyssoftware.treasure2.item.charm.ICharmBuilder;
import net.minecraft.nbt.NBTTagCompound;

public abstract class Charm
implements ICharm {
    public static final int SECOND_IN_TICKS = 20;
    private CharmType type;
    private CharmLevel level;
    private String name;
    private double maxValue;
    private double maxPercent;
    private int maxDuration;
    private double valueModifier;
    private double percentModifier;
    private double durationModifier;

    protected Charm(ICharmBuilder builder) {
        this.name = builder.getName();
        this.type = builder.getType();
        this.level = builder.getLevel();
        this.valueModifier = builder.getCharmValueModifier();
        this.percentModifier = builder.getCharmPercentModifier();
        this.durationModifier = builder.getCharmDurationModifier();
        this.maxValue = (int)(this.type.getBaseValues()[this.level.getValue() - 1] * this.valueModifier);
        this.maxPercent = this.type.getBasePercents()[this.level.getValue() - 1] * this.percentModifier;
        this.maxDuration = (int)((double)this.type.getBaseDurations()[this.level.getValue() - 1] * this.durationModifier);
    }

    public static ICharm readFromNBT(NBTTagCompound tag) {
        String typeStr = tag.func_74779_i("type");
        String levelStr = tag.func_74779_i("level");
        CharmBuilder builder = new CharmBuilder(tag.func_74779_i("name"), CharmType.valueOf(typeStr), CharmLevel.valueOf(levelStr));
        builder.valueModifier(tag.func_74769_h("valueModifier")).percentModifier(tag.func_74769_h("percentModifier")).percentModifier(tag.func_74769_h("durationModifier"));
        return builder.build();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        try {
            if (this.type != null) {
                nbt.func_74778_a("type", this.type.name());
            }
            if (this.level != null) {
                nbt.func_74778_a("level", this.level.name());
            }
            nbt.func_74778_a("name", this.name);
            nbt.func_74780_a("maxValue", this.maxValue);
            nbt.func_74780_a("maxPercent", this.maxPercent);
            nbt.func_74780_a("maxDuration", (double)this.maxDuration);
            nbt.func_74780_a("valueModifier", this.valueModifier);
            nbt.func_74780_a("percentModifier", this.percentModifier);
            nbt.func_74780_a("durationModifier", this.durationModifier);
        }
        catch (Exception e) {
            Treasure.logger.error("Unable to write state to NBT:", (Throwable)e);
        }
        return nbt;
    }

    @Override
    public CharmType getCharmType() {
        return this.type;
    }

    @Override
    public CharmLevel getCharmLevel() {
        return this.level;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public double getMaxPercent() {
        return this.maxPercent;
    }

    @Override
    public int getMaxDuration() {
        return this.maxDuration;
    }

    public CharmType getType() {
        return this.type;
    }

    public CharmLevel getLevel() {
        return this.level;
    }

    public double getValueModifier() {
        return this.valueModifier;
    }

    public double getPercentModifier() {
        return this.percentModifier;
    }

    public void setMaxPercent(double maxPercent) {
        this.maxPercent = maxPercent;
    }

    public double getDurationModifier() {
        return this.durationModifier;
    }

    public String toString() {
        return "Charm [type=" + (Object)((Object)this.type) + ", level=" + (Object)((Object)this.level) + ", name=" + this.name + ", maxValue=" + this.maxValue + ", maxPercent=" + this.maxPercent + ", maxDuration=" + this.maxDuration + ", valueModifier=" + this.valueModifier + ", percentModifier=" + this.percentModifier + ", durationModifier=" + this.durationModifier + "]";
    }
}

