/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item.charm;

import com.someguyssoftware.treasure2.item.charm.Charm;
import com.someguyssoftware.treasure2.item.charm.CharmLevel;
import com.someguyssoftware.treasure2.item.charm.CharmType;
import com.someguyssoftware.treasure2.item.charm.DecayCharm;
import com.someguyssoftware.treasure2.item.charm.FullnessCharm;
import com.someguyssoftware.treasure2.item.charm.HarvestingCharm;
import com.someguyssoftware.treasure2.item.charm.HealingCharm;
import com.someguyssoftware.treasure2.item.charm.ICharm;
import com.someguyssoftware.treasure2.item.charm.ICharmBuilder;
import com.someguyssoftware.treasure2.item.charm.IlluminationCharm;
import com.someguyssoftware.treasure2.item.charm.ShieldingCharm;

public class CharmBuilder
implements ICharmBuilder {
    private final String name;
    private final CharmType type;
    private final CharmLevel level;
    private double charmValueModifier = 1.0;
    private double charmPercentModifier = 1.0;
    private double charmDurationModifier = 1.0;

    public CharmBuilder(String name, CharmType type, CharmLevel level) {
        this.name = name;
        this.type = type;
        this.level = level;
    }

    @Override
    public ICharm build() {
        Charm charm = null;
        switch (this.type) {
            case HEALING: {
                charm = new HealingCharm(this);
                break;
            }
            case SHIELDING: {
                charm = new ShieldingCharm(this);
                break;
            }
            case FULLNESS: {
                charm = new FullnessCharm(this);
                break;
            }
            case HARVESTING: {
                charm = new HarvestingCharm(this);
                break;
            }
            case DECAY: {
                charm = new DecayCharm(this);
                break;
            }
            case ILLUMINATION: {
                charm = new IlluminationCharm(this);
            }
        }
        return charm;
    }

    @Override
    public CharmBuilder valueModifier(double value) {
        this.charmValueModifier = value;
        return this;
    }

    @Override
    public CharmBuilder percentModifier(double percent) {
        this.charmPercentModifier = percent;
        return this;
    }

    public CharmBuilder durationModifier(double duration) {
        this.charmDurationModifier = duration;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CharmType getType() {
        return this.type;
    }

    @Override
    public CharmLevel getLevel() {
        return this.level;
    }

    @Override
    public double getCharmValueModifier() {
        return this.charmValueModifier;
    }

    @Override
    public double getCharmPercentModifier() {
        return this.charmPercentModifier;
    }

    public String toString() {
        return "CharmBuilder [name=" + this.name + ", type=" + (Object)((Object)this.type) + ", level=" + (Object)((Object)this.level) + ", charmValueModifier=" + this.charmValueModifier + ", charmPercentModifier=" + this.charmPercentModifier + ", charmDurationModifier=" + this.charmDurationModifier + "]";
    }

    @Override
    public double getCharmDurationModifier() {
        return this.charmDurationModifier;
    }
}

