/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item.charm;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.item.charm.ICharm;
import com.someguyssoftware.treasure2.item.charm.ICharmVitals;
import net.minecraft.nbt.NBTTagCompound;

public class CharmVitals
implements ICharmVitals {
    private double value;
    private int duration;
    private double percent;

    public CharmVitals() {
    }

    public CharmVitals(ICharm charm) {
        this.value = charm.getMaxValue();
        this.duration = charm.getMaxDuration();
        this.percent = charm.getMaxPercent();
    }

    public CharmVitals(double value, int duration, double percent) {
        this.value = value;
        this.duration = duration;
        this.percent = percent;
    }

    public CharmVitals(ICharmVitals vitals) {
        this.value = vitals.getValue();
        this.duration = vitals.getDuration();
        this.percent = vitals.getPercent();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("duration")) {
            this.duration = nbt.func_74762_e("duration");
        }
        if (nbt.func_74764_b("value")) {
            this.value = nbt.func_74762_e("value");
        }
        if (nbt.func_74764_b("percent")) {
            this.percent = nbt.func_74769_h("percent");
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        try {
            nbt.func_74768_a("duration", this.getDuration());
            nbt.func_74780_a("value", this.getValue());
            nbt.func_74780_a("percent", this.getPercent());
        }
        catch (Exception e) {
            Treasure.logger.error("Unable to write state to NBT:", (Throwable)e);
        }
        return nbt;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public double getPercent() {
        return this.percent;
    }

    @Override
    public void setPercent(double percent) {
        this.percent = percent;
    }

    public String toString() {
        return "CharmVitals [value=" + this.value + ", duration=" + this.duration + ", percent=" + this.percent + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.duration;
        long temp = Double.doubleToLongBits(this.percent);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CharmVitals other = (CharmVitals)obj;
        if (this.duration != other.duration) {
            return false;
        }
        if (Double.doubleToLongBits(this.percent) != Double.doubleToLongBits(other.percent)) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }
}

