/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item.charm;

import com.someguyssoftware.treasure2.capability.CharmCapabilityProvider;
import com.someguyssoftware.treasure2.capability.ICharmCapability;
import com.someguyssoftware.treasure2.item.charm.CharmType;
import com.someguyssoftware.treasure2.item.charm.ICharmState;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public interface ICharmed {
    default public List<ICharmState> getCharmStates(ItemStack stack) {
        ICharmCapability cap;
        List<ICharmState> charmStates = null;
        if (stack.hasCapability(CharmCapabilityProvider.CHARM_CAPABILITY, null) && (cap = (ICharmCapability)stack.getCapability(CharmCapabilityProvider.CHARM_CAPABILITY, null)) != null) {
            charmStates = cap.getCharmStates();
        }
        return charmStates;
    }

    default public void addCharmedInfo(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD.toString() + "" + TextFormatting.ITALIC.toString() + I18n.func_74838_a((String)"tooltip.label.charmed"));
        tooltip.add(TextFormatting.YELLOW.toString() + "" + TextFormatting.BOLD + I18n.func_74838_a((String)"tooltip.label.charms"));
        ICharmCapability cap = (ICharmCapability)stack.getCapability(CharmCapabilityProvider.CHARM_CAPABILITY, null);
        if (cap != null) {
            List<ICharmState> charmStates = cap.getCharmStates();
            for (ICharmState state : charmStates) {
                TextFormatting color = TextFormatting.WHITE;
                CharmType type = state.getCharm().getCharmType();
                String extra = "";
                switch (type) {
                    case HEALING: {
                        color = TextFormatting.RED;
                        extra = TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_74837_a((String)"tooltip.charm.healing_rate", (Object[])new Object[0]);
                        break;
                    }
                    case SHIELDING: {
                        color = TextFormatting.AQUA;
                        extra = TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_74837_a((String)"tooltip.charm.shield_rate", (Object[])new Object[]{state.getCharm().getMaxPercent() * 100.0});
                        break;
                    }
                    case FULLNESS: {
                        color = TextFormatting.DARK_GREEN;
                        extra = TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_74837_a((String)"tooltip.charm.fullness_rate", (Object[])new Object[0]);
                        break;
                    }
                    case HARVESTING: {
                        color = TextFormatting.GREEN;
                        extra = TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_74837_a((String)"tooltip.charm.harvest_rate", (Object[])new Object[]{state.getCharm().getMaxPercent()});
                        break;
                    }
                    case DECAY: {
                        color = TextFormatting.DARK_RED;
                        extra = TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_74837_a((String)"tooltip.charm.decay_rate", (Object[])new Object[0]);
                        break;
                    }
                    case ILLUMINATION: {
                        color = TextFormatting.WHITE;
                        extra = TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_74837_a((String)"tooltip.charm.illumination_rate", (Object[])new Object[0]);
                    }
                }
                tooltip.add("  " + color + I18n.func_74837_a((String)("tooltip.charm." + state.getCharm().getName()), (Object[])new Object[]{String.valueOf(Math.toIntExact(Math.round(state.getVitals().getValue()))), String.valueOf(Math.toIntExact(Math.round(state.getCharm().getMaxValue())))}));
                if ("".equals(extra)) continue;
                tooltip.add(" " + extra);
            }
        }
    }
}

