/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item.charm;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.item.charm.CharmVitals;
import com.someguyssoftware.treasure2.item.charm.ICharm;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class IlluminationCharmVitals
extends CharmVitals {
    private List<ICoords> coordsList = Collections.synchronizedList(new LinkedList());

    public IlluminationCharmVitals() {
    }

    public IlluminationCharmVitals(ICharm charm) {
        this();
        this.setValue(charm.getMaxValue());
        this.setDuration(charm.getMaxDuration());
        this.setPercent(charm.getMaxPercent());
    }

    public IlluminationCharmVitals(double value, int duration, double percent) {
        this();
        this.setValue(value);
        this.setDuration(duration);
        this.setPercent(percent);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTTagList list = nbt.func_150295_c("illuminationCoords", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ICoords coords = ICoords.readFromNBT((NBTTagCompound)tag);
            if (coords == null) continue;
            this.getCoordsList().add(coords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        try {
            NBTTagList list = new NBTTagList();
            List<ICoords> list2 = this.coordsList;
            synchronized (list2) {
                for (ICoords coords : this.coordsList) {
                    NBTTagCompound coordsTag = new NBTTagCompound();
                    coords.writeToNBT(coordsTag);
                    list.func_74742_a((NBTBase)coordsTag);
                }
            }
            nbt.func_82580_o("illuminationCoords");
            nbt.func_74782_a("illuminationCoords", (NBTBase)list);
        }
        catch (Exception e) {
            Treasure.logger.error("Unable to write state to NBT:", (Throwable)e);
        }
        return nbt;
    }

    public List<ICoords> getCoordsList() {
        if (this.coordsList == null) {
            this.coordsList = new LinkedList<ICoords>();
        }
        return this.coordsList;
    }

    public void setCoordsList(List<ICoords> blockList) {
        this.coordsList = blockList;
    }

    @Override
    public String toString() {
        return "IlluminationCharmVitals [coordsList=" + this.coordsList + ", toString()=" + super.toString() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.coordsList == null ? 0 : this.coordsList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IlluminationCharmVitals other = (IlluminationCharmVitals)obj;
        return !(this.coordsList == null ? other.coordsList != null : !this.coordsList.equals(other.coordsList));
    }
}

