/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.loot.function;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.someguyssoftware.gottschcore.loot.LootContext;
import com.someguyssoftware.gottschcore.loot.conditions.LootCondition;
import com.someguyssoftware.gottschcore.loot.functions.LootFunction;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.CharmCapabilityProvider;
import com.someguyssoftware.treasure2.capability.ICharmCapability;
import com.someguyssoftware.treasure2.item.charm.CharmLevel;
import com.someguyssoftware.treasure2.item.charm.CharmStateFactory;
import com.someguyssoftware.treasure2.item.charm.CharmType;
import com.someguyssoftware.treasure2.item.charm.ICharm;
import com.someguyssoftware.treasure2.item.charm.ICharmState;
import com.someguyssoftware.treasure2.item.charm.TreasureCharms;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class CharmRandomly
extends LootFunction {
    private List<ICharm> charms;

    public CharmRandomly(LootCondition[] conditions, @Nullable List<ICharm> charms) {
        super(conditions);
        this.charms = charms == null ? Collections.emptyList() : charms;
    }

    public ItemStack apply(ItemStack stack, Random rand, LootContext context) {
        ICharm charm = null;
        if (stack.hasCapability(CharmCapabilityProvider.CHARM_CAPABILITY, null)) {
            ICharmCapability provider = (ICharmCapability)stack.getCapability(CharmCapabilityProvider.CHARM_CAPABILITY, null);
            List<ICharmState> charmStates = provider.getCharmStates();
            if (this.charms.isEmpty()) {
                ArrayList<ICharm> tempCharms = new ArrayList<ICharm>();
                for (ICharm c : TreasureCharms.REGISTRY.values()) {
                    if (c.getCharmLevel() != CharmLevel.LEVEL1 && c.getCharmLevel() != CharmLevel.LEVEL2) continue;
                    tempCharms.add(c);
                }
                if (!tempCharms.isEmpty()) {
                    charm = (ICharm)tempCharms.get(rand.nextInt(tempCharms.size()));
                }
            } else {
                charm = this.charms.get(rand.nextInt(this.charms.size()));
                Treasure.logger.debug("selected charm for item -> {}", (Object)charm.getName());
            }
            if (charm != null) {
                boolean hasCharm = false;
                for (ICharmState state : charmStates) {
                    if (state.getCharm().getCharmType() != charm.getCharmType() && !state.getCharm().getName().equals(charm.getName())) continue;
                    hasCharm = true;
                    break;
                }
                if (!hasCharm) {
                    charmStates.add(CharmStateFactory.createCharmState(charm));
                }
            }
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<CharmRandomly> {
        public Serializer() {
            super(new ResourceLocation("treasure2:charm_randomly"), CharmRandomly.class);
        }

        public void serialize(JsonObject json, CharmRandomly value, JsonSerializationContext context) {
            if (!value.charms.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (ICharm charm : value.charms) {
                    jsonArray.add((JsonElement)new JsonPrimitive(charm.getName()));
                }
                json.add("charms", (JsonElement)jsonArray);
            }
        }

        public CharmRandomly deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            HashMap<CharmType, ICharm> charmsByType = new HashMap<CharmType, ICharm>(10);
            ArrayList list = Lists.newArrayList();
            if (json.has("charms")) {
                for (JsonElement element : JsonUtils.func_151214_t((JsonObject)json, (String)"charms")) {
                    String charmName = JsonUtils.func_151206_a((JsonElement)element, (String)"charm");
                    ICharm charm = TreasureCharms.REGISTRY.get(charmName);
                    if (charm == null) {
                        Treasure.logger.warn("Unknown charm '{}'", (Object)charmName);
                    }
                    if (charmsByType.containsKey((Object)charm.getCharmType())) continue;
                    charmsByType.put(charm.getCharmType(), charm);
                    list.add(charm);
                }
            }
            return new CharmRandomly(conditionsIn, list);
        }
    }
}

