/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.meta;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.enums.IRarity;
import com.someguyssoftware.gottschcore.json.JSMin;
import com.someguyssoftware.gottschcore.meta.IMeta;
import com.someguyssoftware.gottschcore.meta.IMetaArchetype;
import com.someguyssoftware.gottschcore.meta.IMetaTheme;
import com.someguyssoftware.gottschcore.meta.IMetaType;
import com.someguyssoftware.gottschcore.meta.MetaManager;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.meta.StructureArchetype;
import com.someguyssoftware.treasure2.meta.StructureMeta;
import com.someguyssoftware.treasure2.meta.StructureTheme;
import com.someguyssoftware.treasure2.meta.StructureType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class TreasureMetaManager
extends MetaManager {
    private static List<String> FOLDER_LOCATIONS = ImmutableList.of((Object)"structures");

    public TreasureMetaManager(IMod mod, String resourceFolder) {
        super(mod, resourceFolder);
        this.buildAndExpose(this.getBaseResourceFolder(), "treasure2", FOLDER_LOCATIONS);
    }

    public void clear() {
        super.clear();
    }

    public void register(String modID) {
        for (String location : FOLDER_LOCATIONS) {
            Treasure.logger.debug("registering meta files from location -> {}", (Object)location);
            List locs = this.getResourceLocations(modID, location);
            for (ResourceLocation loc : locs) {
                Path path = Paths.get(loc.func_110623_a(), new String[0]);
                if (Treasure.logger.isDebugEnabled()) {
                    Treasure.logger.debug("path to meta resource loc -> {}", (Object)path.toString());
                }
                Treasure.logger.debug("attempted to load custom meta file  with key -> {}", (Object)loc.toString());
                IMeta meta = this.load(loc);
                if (meta == null) {
                    Treasure.logger.debug("Unable to locate meta file -> {}", (Object)loc.toString());
                    continue;
                }
                Treasure.logger.debug("loaded custom meta file  with key -> {}", (Object)loc.toString());
            }
        }
    }

    protected void readFromStream(String id, InputStream stream) throws IOException, Exception {
        Treasure.logger.debug("reading meta file from stream.");
        IMeta meta = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JSMin minifier = new JSMin(stream, (OutputStream)out);
        minifier.jsmin();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        InputStreamReader reader = new InputStreamReader(in);
        JsonReader jsonReader = new JsonReader((Reader)reader);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Type metaArchetype = new TypeToken<List<IMetaArchetype>>(){}.getType();
        Type metaTheme = new TypeToken<List<IMetaTheme>>(){}.getType();
        Type rarity = new TypeToken<List<IRarity>>(){}.getType();
        gsonBuilder.registerTypeAdapter(metaArchetype, (Object)new MetaArchetypeDeserializer());
        gsonBuilder.registerTypeAdapter(IMetaType.class, (Object)new MetaTypeDeserializer());
        gsonBuilder.registerTypeAdapter(metaTheme, (Object)new MetaThemeDeserializer());
        gsonBuilder.registerTypeAdapter(rarity, (Object)new RarityDeserializer());
        gsonBuilder.registerTypeAdapter(ICoords.class, (Object)new CoordsDeserializer());
        Gson gson = gsonBuilder.create();
        try {
            meta = (IMeta)gson.fromJson(jsonReader, StructureMeta.class);
            Treasure.logger.debug("meta[{}] -> {}", (Object)id, (Object)meta);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new Exception("Unable to load meta file:", e);
        }
        finally {
            try {
                jsonReader.close();
            }
            catch (IOException e) {
                GottschCore.logger.warn("Unable to close JSON Reader when reading meta file.");
            }
        }
        this.getMetaMap().put(id, meta);
    }

    public static class CoordsDeserializer
    implements JsonDeserializer<Coords> {
        public Coords deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return (Coords)context.deserialize(json, Coords.class);
        }
    }

    public static class RarityDeserializer
    implements JsonDeserializer<List<IRarity>> {
        public List<IRarity> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ArrayList<IRarity> list = new ArrayList<IRarity>();
            JsonArray array = json.getAsJsonArray();
            for (JsonElement e : array) {
                list.add(Rarity.valueOf(e.getAsString().toUpperCase()));
            }
            return list;
        }
    }

    public static class MetaThemeDeserializer
    implements JsonDeserializer<List<IMetaTheme>> {
        public List<IMetaTheme> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ArrayList<IMetaTheme> list = new ArrayList<IMetaTheme>();
            JsonArray array = json.getAsJsonArray();
            for (JsonElement e : array) {
                list.add(StructureTheme.valueOf(e.getAsString().toUpperCase()));
            }
            return list;
        }
    }

    public static class MetaTypeDeserializer
    implements JsonDeserializer<StructureType> {
        public StructureType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return StructureType.valueOf(json.getAsString().toUpperCase());
        }
    }

    public static class MetaArchetypeDeserializer
    implements JsonDeserializer<List<IMetaArchetype>> {
        public List<IMetaArchetype> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ArrayList<IMetaArchetype> list = new ArrayList<IMetaArchetype>();
            JsonArray array = json.getAsJsonArray();
            for (JsonElement e : array) {
                list.add(StructureArchetype.valueOf(e.getAsString().toUpperCase()));
            }
            return list;
        }
    }
}

