/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.network;

import com.someguyssoftware.treasure2.item.charm.CharmStateFactory;
import com.someguyssoftware.treasure2.item.charm.ICharmState;
import com.someguyssoftware.treasure2.item.charm.ICharmVitals;
import com.someguyssoftware.treasure2.item.charm.TreasureCharms;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CharmMessageToClient
implements IMessage {
    private boolean messageIsValid;
    private String charmName;
    private ICharmVitals vitals;
    private String playerName;
    private EnumHand hand;
    private Integer slot;

    public CharmMessageToClient(String playerName, ICharmState state, EnumHand hand, Integer slot) {
        this.messageIsValid = true;
        this.playerName = playerName;
        this.charmName = state.getCharm().getName();
        this.vitals = state.getVitals();
        this.hand = hand;
        this.slot = slot == null ? Integer.valueOf(-1) : slot;
    }

    public CharmMessageToClient() {
        this.messageIsValid = false;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.charmName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            double value = buf.readDouble();
            int duration = buf.readInt();
            double percent = buf.readDouble();
            this.vitals = CharmStateFactory.createCharmVitals(TreasureCharms.REGISTRY.get(this.charmName));
            this.vitals.setDuration(duration);
            this.vitals.setPercent(percent);
            this.vitals.setValue(value);
            String handStr = ByteBufUtils.readUTF8String((ByteBuf)buf);
            if (!handStr.isEmpty()) {
                this.hand = EnumHand.valueOf((String)handStr);
            }
            this.slot = buf.readInt();
        }
        catch (RuntimeException e) {
            System.err.println("Exception while reading PoisonMistMessageToServer: " + e);
            return;
        }
        this.messageIsValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageIsValid) {
            return;
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.charmName);
        buf.writeDouble(this.vitals.getValue());
        buf.writeInt(this.vitals.getDuration());
        buf.writeDouble(this.vitals.getPercent());
        String handStr = "";
        if (this.hand != null) {
            handStr = this.hand.name();
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)handStr);
        buf.writeInt(this.slot.intValue());
    }

    public boolean isMessageValid() {
        return this.charmName != null && this.playerName != null && this.vitals != null;
    }

    public boolean isMessageIsValid() {
        return this.messageIsValid;
    }

    public void setMessageIsValid(boolean messageIsValid) {
        this.messageIsValid = messageIsValid;
    }

    public ICharmVitals getVitals() {
        return this.vitals;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public EnumHand getHand() {
        return this.hand;
    }

    public Integer getSlot() {
        return this.slot;
    }

    public String getCharmName() {
        return this.charmName;
    }

    public String toString() {
        return "CharmMessageToClient [messageIsValid=" + this.messageIsValid + ", charmName=" + this.charmName + ", vitals=" + this.vitals + ", playerName=" + this.playerName + ", hand=" + this.hand + ", slot=" + this.slot + "]";
    }
}

