/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.printer;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.lock.LockState;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;

public class ChestNBTPrettyPrinter {
    private static final String div;
    private static final String sub;
    private static String format2;
    private static String heading2;

    public String print(NBTTagCompound tag, Path path) {
        return this.print(tag, path, "CHEST");
    }

    public String print(NBTTagCompound tag, Path path, String title) {
        String s = this.print(tag, title);
        try {
            Files.write(path.toAbsolutePath(), s.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Treasure.logger.error("Error writing ChestConfig NBT to dump file", (Throwable)e);
        }
        return s;
    }

    public String print(NBTTagCompound tag, String title) {
        StringBuilder sb = new StringBuilder();
        try {
            NBTTagCompound c;
            int i;
            String heading = "**  %1$-67s  **\n";
            String format = "**    %1$-33s: %2$-30s  **\n";
            String format3 = "**    %1$-63s  **\n";
            sb.append(div).append(String.format(heading, title)).append(div).append(String.format(heading, "[Properties]"));
            NBTTagList lockStates = null;
            if (tag.func_74764_b("lockStates")) {
                lockStates = tag.func_150295_c("lockStates", 10);
            }
            sb.append(String.format(format, "# of Lock States", lockStates != null ? lockStates.func_74745_c() : 0));
            NBTTagList items = null;
            if (tag.func_74764_b("Items")) {
                items = tag.func_150295_c("Items", 10);
            }
            sb.append(String.format(format, "# of Items", items != null ? items.func_74745_c() : 0));
            if (tag.func_74764_b("CustomName")) {
                sb.append(String.format(format, "Custom Name", tag.func_74779_i("CustomName")));
            }
            if (tag.func_74764_b("facing")) {
                sb.append(String.format(format, "Facing", EnumFacing.func_82600_a((int)tag.func_74762_e("facing"))));
            }
            if (lockStates != null) {
                for (i = 0; i < lockStates.func_74745_c(); ++i) {
                    c = lockStates.func_150305_b(i);
                    LockState lockState = LockState.readFromNBT(c);
                    sb.append(sub).append(String.format(heading2, "[Lock State]"));
                    if (lockState.getSlot() != null) {
                        sb.append(String.format(format2, "Slot Face", lockState.getSlot().getFace()));
                    }
                    if (lockState.getLock() == null) continue;
                    sb.append(String.format(format2, "Lock", ((Object)((Object)lockState.getLock())).getClass().getSimpleName())).append(String.format(format2, "Registry Name", lockState.getLock().getRegistryName())).append(String.format(format2, "Unlocalized Name", lockState.getLock().func_77658_a()));
                }
            }
            sb.append(div);
            for (i = 0; i < items.func_74745_c(); ++i) {
                c = items.func_150305_b(i);
                int slot = c.func_74771_c("Slot") & 0xFF;
                if (!c.func_150297_b("id", 8)) continue;
                String item = c.func_74779_i("id");
                sb.append(String.format(format2, "Slot " + slot, item));
            }
            sb.append(div);
            sb.append("\n");
        }
        catch (Exception e) {
            Treasure.logger.error("Error dumping ChestConfig NBT", (Throwable)e);
            return e.getMessage();
        }
        return sb.toString();
    }

    static {
        format2 = "**++    %1$-31s: %2$-28s  ++**\n";
        heading2 = "**++  %1$-63s  ++**\n";
        char[] chars = new char[75];
        Arrays.fill(chars, '*');
        div = new String(chars) + "\n";
        Arrays.fill(chars, '+');
        chars[74] = 42;
        chars[73] = 42;
        chars[1] = 42;
        chars[0] = 42;
        sub = new String(chars) + "\n";
    }
}

