/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.registry;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.generator.oasis.OasisInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OasisRegistry {
    private static OasisRegistry instance = new OasisRegistry();
    private Map<Integer, ListMultimap<String, OasisInfo>> registry = new HashMap<Integer, ListMultimap<String, OasisInfo>>();

    private OasisRegistry() {
    }

    public static OasisRegistry getInstance() {
        return instance;
    }

    public boolean isRegistered(Integer dimensionID, String key) {
        if (this.registry.containsKey(dimensionID)) {
            ListMultimap<String, OasisInfo> map = this.registry.get(dimensionID);
            return this.registry.containsKey(key);
        }
        return false;
    }

    public synchronized void register(Integer dimensionID, String key, OasisInfo info) {
        ListMultimap<String, OasisInfo> map;
        Treasure.logger.debug("Registering oasis in dimension -> {} using key -> {} ", (Object)dimensionID, (Object)key);
        if (!this.registry.containsKey(dimensionID)) {
            this.registry.put(dimensionID, (ListMultimap<String, OasisInfo>)LinkedListMultimap.create());
        }
        if ((map = this.registry.get(dimensionID)).size() >= TreasureConfig.OASES.oasisRegistrySize) {
            String headKey = (String)map.keySet().iterator().next();
            this.unregister(dimensionID, headKey);
        }
        map.put((Object)key, (Object)info);
    }

    public synchronized void unregister(Integer dimensionID, String key) {
        ListMultimap<String, OasisInfo> map;
        if (this.registry.containsKey(dimensionID) && (map = this.registry.get(dimensionID)).containsKey((Object)key)) {
            map.removeAll((Object)key);
        }
    }

    public List<OasisInfo> get(Integer dimensionID, String key) {
        ListMultimap<String, OasisInfo> map;
        List info = null;
        if (this.registry.containsKey(dimensionID) && (map = this.registry.get(dimensionID)).containsKey((Object)key)) {
            info = map.get((Object)key);
        }
        return info;
    }

    public Set<Integer> getDimensionKeys() {
        return this.registry.keySet();
    }

    public ListMultimap<String, OasisInfo> getDimensionEntry(Integer dimensionID) {
        return LinkedListMultimap.create((Multimap)((Multimap)this.registry.get(dimensionID)));
    }

    public List<OasisInfo> getValues(Integer dimensionID) {
        if (this.registry.containsKey(dimensionID)) {
            ListMultimap<String, OasisInfo> map = this.registry.get(dimensionID);
            HashSet set = Sets.newHashSet((Iterable)map.values());
            return new ArrayList<OasisInfo>(set);
        }
        return new ArrayList<OasisInfo>();
    }

    public void clear() {
        this.registry.clear();
    }
}

