/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.worldgen;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.generator.GeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.oasis.DesertOasisGenerator;
import com.someguyssoftware.treasure2.generator.oasis.IOasisGenerator;
import com.someguyssoftware.treasure2.generator.oasis.OasisInfo;
import com.someguyssoftware.treasure2.registry.OasisRegistry;
import com.someguyssoftware.treasure2.worldgen.ITreasureWorldGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class OasisWorldGenerator
implements ITreasureWorldGenerator {
    public static final int CHUNK_RADIUS = 8;
    private Map<Integer, Integer> chunksSinceLastDimensionOasis;
    private Map<Integer, Map<Integer, Integer>> chunksSinceLastDimensionBiomeOasis;
    private Multimap<Integer, IOasisGenerator<?>> oasisGenerators;

    public OasisWorldGenerator() {
        try {
            this.init();
        }
        catch (Exception e) {
            Treasure.logger.error("Unable to instantiate OasisGenerator:", (Throwable)e);
        }
    }

    @Override
    public void init() {
        this.chunksSinceLastDimensionOasis = new HashMap<Integer, Integer>();
        this.chunksSinceLastDimensionBiomeOasis = new HashMap<Integer, Map<Integer, Integer>>();
        for (Integer dimensionId : TreasureConfig.WORLD_GEN.getGeneralProperties().getDimensionsWhiteList()) {
            this.chunksSinceLastDimensionOasis.put(dimensionId, 0);
            this.chunksSinceLastDimensionBiomeOasis.put(dimensionId, new HashMap());
        }
        this.oasisGenerators = ArrayListMultimap.create();
        if (TreasureConfig.OASES.desertOasisProperties.isEnableOasis()) {
            this.registerOasisByBiomes(new DesertOasisGenerator());
        }
    }

    private void registerOasisByBiomes(IOasisGenerator<?> oasisGenerator) {
        block5: {
            List<Biome> biomeBlackList;
            block6: {
                List<Biome> biomeWhiteList;
                block4: {
                    biomeWhiteList = oasisGenerator.getConfig().getBiomeWhiteList();
                    biomeBlackList = oasisGenerator.getConfig().getBiomeBlackList();
                    if (!biomeWhiteList.isEmpty() || !biomeBlackList.isEmpty()) break block4;
                    Set biomes = (Set)ForgeRegistries.BIOMES.getValuesCollection();
                    for (Biome biome : biomes) {
                        Integer biomeID = Biome.func_185362_a((Biome)biome);
                        if (this.oasisGenerators.containsKey((Object)biomeID)) continue;
                        this.oasisGenerators.put((Object)biomeID, oasisGenerator);
                    }
                    break block5;
                }
                if (biomeWhiteList.isEmpty()) break block6;
                for (Biome biome : biomeWhiteList) {
                    Integer biomeID = Biome.func_185362_a((Biome)biome);
                    if (this.oasisGenerators.containsKey((Object)biomeID)) continue;
                    this.oasisGenerators.put((Object)biomeID, oasisGenerator);
                }
                break block5;
            }
            if (biomeBlackList.isEmpty()) break block5;
            ArrayList<Integer> blackListBiomeIDs = new ArrayList<Integer>();
            for (Biome biome : biomeBlackList) {
                Integer biomeID = Biome.func_185362_a((Biome)biome);
                if (biomeID == null) continue;
                blackListBiomeIDs.add(biomeID);
            }
            Set biomes = (Set)ForgeRegistries.BIOMES.getValuesCollection();
            for (Biome biome : biomes) {
                Integer biomeID;
                if (blackListBiomeIDs.contains(Biome.func_185362_a((Biome)biome)) || this.oasisGenerators.containsKey((Object)(biomeID = Integer.valueOf(Biome.func_185362_a((Biome)biome))))) continue;
                this.oasisGenerators.put((Object)biomeID, oasisGenerator);
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (TreasureConfig.WORLD_GEN.getGeneralProperties().getDimensionsWhiteList().contains(world.field_73011_w.getDimension())) {
            this.generate(world, random, chunkX, chunkZ);
        }
    }

    public void generate(World world, Random random, int chunkX, int chunkZ) {
        int xSpawn = chunkX * 16 + 8;
        int zSpawn = chunkZ * 16 + 8;
        Integer dimensionID = world.field_73011_w.getDimension();
        Integer chunksSinceLast = this.chunksSinceLastDimensionOasis.get(dimensionID);
        chunksSinceLast = chunksSinceLast + 1;
        this.chunksSinceLastDimensionOasis.put(dimensionID, chunksSinceLast);
        Coords coords = new Coords(xSpawn, 255, zSpawn);
        Biome biome = world.func_180494_b(coords.toPos());
        Integer biomeID = Biome.func_185362_a((Biome)biome);
        if (chunksSinceLast >= TreasureConfig.OASES.minChunksPerOasis) {
            Optional<List> generators = Optional.ofNullable((List)this.oasisGenerators.get((Object)biomeID));
            if (!generators.isPresent() || generators.get().isEmpty()) {
                return;
            }
            IOasisGenerator generator = (IOasisGenerator)generators.get().get(random.nextInt(generators.get().size()));
            Integer chunksPerDimensionBiome = this.chunksSinceLastDimensionBiomeOasis.get(dimensionID).get(biomeID);
            if (chunksPerDimensionBiome == null) {
                chunksPerDimensionBiome = 0;
            }
            chunksPerDimensionBiome = chunksPerDimensionBiome + 1;
            this.chunksSinceLastDimensionBiomeOasis.get(dimensionID).put(biomeID, chunksPerDimensionBiome);
            if (chunksPerDimensionBiome >= generator.getConfig().getChunksPerOasis()) {
                if (!RandomHelper.checkProbability((Random)random, (double)generator.getConfig().getGenProbability())) {
                    Treasure.logger.debug("Oasis does not meet generate probability of -> {}", (Object)generator.getConfig().getGenProbability());
                    return;
                }
                if (this.isRegisteredOasisWithinDistance(world, (ICoords)coords, dimensionID, TreasureConfig.OASES.minDistancePerOasis)) {
                    Treasure.logger.debug("The distance to the nearest oasis is less than the minimun required.");
                    return;
                }
                this.chunksSinceLastDimensionBiomeOasis.get(dimensionID).put(biomeID, 0);
                Treasure.logger.debug("Attempting to generate oasis @ {}", (Object)coords.toShortString());
                Optional<GeneratorResult<GeneratorData>> result = Optional.ofNullable(generator.generate(world, random, (ICoords)coords));
                if (result.isPresent() && result.get().isSuccess()) {
                    OasisRegistry.getInstance().register(dimensionID, coords.toShortString(), new OasisInfo(result.get().getData().getSpawnCoords(), dimensionID, biomeID));
                    this.chunksSinceLastDimensionOasis.put(dimensionID, 0);
                }
            }
        }
    }

    private boolean isRegisteredOasisWithinDistance(World world, ICoords coords, Integer dimensionID, int minDistance) {
        double minDistanceSq = minDistance * minDistance;
        List<OasisInfo> oasisInfos = OasisRegistry.getInstance().getValues(dimensionID);
        if (oasisInfos == null || oasisInfos.size() == 0) {
            Treasure.logger.debug("Unable to locate the OasisConfig Registry or the Registry doesn't contain any values");
            return false;
        }
        for (OasisInfo info : oasisInfos) {
            double distance = coords.getDistanceSq(info.getCoords());
            if (!(distance < minDistanceSq)) continue;
            return true;
        }
        return false;
    }

    public Multimap<Integer, IOasisGenerator<?>> getOasisGenerators() {
        return this.oasisGenerators;
    }

    public void setOasisGenerators(Multimap<Integer, IOasisGenerator<?>> oasisGenerators) {
        this.oasisGenerators = oasisGenerators;
    }

    public Map<Integer, Integer> getChunksSinceLastDimensionOasis() {
        return this.chunksSinceLastDimensionOasis;
    }

    public void setChunksSinceLastDimensionOasis(Map<Integer, Integer> chunksSinceLastDimensionOasis) {
        this.chunksSinceLastDimensionOasis = chunksSinceLastDimensionOasis;
    }

    public Map<Integer, Map<Integer, Integer>> getChunksSinceLastDimensionBiomeOasis() {
        return this.chunksSinceLastDimensionBiomeOasis;
    }

    public void setChunksSinceLastDimensionBiomeOasis(Map<Integer, Map<Integer, Integer>> chunksSinceLastDimensionBiomeOasis) {
        this.chunksSinceLastDimensionBiomeOasis = chunksSinceLastDimensionBiomeOasis;
    }
}

