/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.worldgen;

import com.someguyssoftware.gottschcore.biome.BiomeHelper;
import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.biome.TreasureBiomeHelper;
import com.someguyssoftware.treasure2.block.FogBlock;
import com.someguyssoftware.treasure2.block.ITreasureBlock;
import com.someguyssoftware.treasure2.block.SpanishMossBlock;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.block.WitherBranchBlock;
import com.someguyssoftware.treasure2.block.WitherLogSoulBlock;
import com.someguyssoftware.treasure2.block.WitherRootBlock;
import com.someguyssoftware.treasure2.chest.ChestInfo;
import com.someguyssoftware.treasure2.config.IWitherTreeConfig;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.chest.WitherChestGenerator;
import com.someguyssoftware.treasure2.persistence.GenDataPersistence;
import com.someguyssoftware.treasure2.registry.ChestRegistry;
import com.someguyssoftware.treasure2.worldgen.ITreasureWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.SurfaceChestWorldGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;

public class WitherTreeWorldGenerator
implements ITreasureWorldGenerator {
    public static final int VERTICAL_MAX_DIFF = 3;
    private static final int CLEARING_RADIUS = 7;
    private static final int DIRT_REPLACEMENT_PROBABILITY = 90;
    private static final int DEGREES = 360;
    private static final double MIN_RADIUS = 5.0;
    private static final double MAX_RADIUS = 10.0;
    private static final int MIN_MAIN_TREE_SIZE = 9;
    private static final int MIN_TREE_SIZE = 7;
    private static final int WITHER_ROOT_PROBABILITY = 50;
    private static final int WITHER_BRANCH_PROBABILITY = 30;
    private static final int SPANISH_MOSS_PROBABILITY = 80;
    private static final int MAX_ROCKS = 5;
    private static final int MIN_ROCKS = 0;
    private static final int MIN_SCRUB = 5;
    private static final int MAX_SCRUB = 20;
    FogBlock[] fogDensity = new FogBlock[0];
    FogBlock[] poisonFogDensity = new FogBlock[0];
    static List<Direction>[] trunkMatrix = new ArrayList[4];
    static List<Direction> supportTrunkMatrix = new ArrayList<Direction>();
    static List<Direction> topMatrix = new ArrayList<Direction>();
    private int chunksSinceLastTree;

    public WitherTreeWorldGenerator() {
        try {
            this.init();
        }
        catch (Exception e) {
            Treasure.logger.error("Unable to instantiate SurfaceChestGenerator:", (Throwable)e);
        }
    }

    @Override
    public void init() {
        this.chunksSinceLastTree = 0;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (TreasureConfig.WORLD_GEN.getGeneralProperties().getDimensionsWhiteList().contains(world.field_73011_w.getDimension())) {
            this.generate(world, random, chunkX, chunkZ);
        }
    }

    private void generate(World world, Random random, int chunkX, int chunkZ) {
        int xSpawn = chunkX * 16 + 8;
        int zSpawn = chunkZ * 16 + 8;
        Coords coords = new Coords(xSpawn, 0, zSpawn);
        Biome biome = world.func_180494_b(coords.toPos());
        if (biome == Biomes.field_76771_b || biome == Biomes.field_150575_M || biome == Biomes.field_76776_l || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            return;
        }
        ++this.chunksSinceLastTree;
        if (this.chunksSinceLastTree > TreasureConfig.WITHER_TREE.chunksPerTree) {
            GenDataPersistence savedData;
            int ySpawn = world.func_72964_e(chunkX, chunkZ).func_76611_b(8, 8);
            coords = new Coords(xSpawn, ySpawn, zSpawn);
            TreasureConfig.WitherTree treeConfig = TreasureConfig.WITHER_TREE;
            if (treeConfig == null) {
                Treasure.logger.warn("Unable to locate a config for wither tree {}.", (Object)treeConfig);
                return;
            }
            if (this.chunksSinceLastTree >= treeConfig.getChunksPerTree()) {
                TreasureBiomeHelper.Result biomeCheck = TreasureBiomeHelper.isBiomeAllowed(biome, treeConfig.getBiomeWhiteList(), treeConfig.getBiomeBlackList());
                if (biomeCheck == TreasureBiomeHelper.Result.BLACK_LISTED) {
                    this.chunksSinceLastTree = 0;
                    return;
                }
                if (biomeCheck == TreasureBiomeHelper.Result.OK && !BiomeHelper.isBiomeAllowed((Biome)biome, treeConfig.getBiomeTypeWhiteList(), treeConfig.getBiomeTypeBlackList())) {
                    if (Treasure.logger.isDebugEnabled()) {
                        if (WorldInfo.isClientSide((World)world)) {
                            Treasure.logger.debug("{} is not a valid biome @ {} for Wither Tree", (Object)biome.func_185359_l(), (Object)coords.toShortString());
                        } else {
                            Treasure.logger.debug("Biome is not valid @ {} for Wither Tree", (Object)coords.toShortString());
                        }
                    }
                    this.chunksSinceLastTree = 0;
                    return;
                }
                if (!RandomHelper.checkProbability((Random)random, (double)treeConfig.getGenProbability())) {
                    Treasure.logger.debug("Wither does not meet generate probability.");
                    return;
                }
                if (this.isRegisteredChestWithinDistance(world, (ICoords)coords, TreasureConfig.CHESTS.surfaceChests.minDistancePerChest)) {
                    Treasure.logger.debug("The distance to the nearest treasure chest is less than the minimun required.");
                    return;
                }
                this.chunksSinceLastTree = 0;
                Treasure.logger.debug("Attempting to generate a wither tree");
                GeneratorResult<GeneratorData> result = this.generate(world, random, (ICoords)coords, treeConfig);
                if (result.isSuccess()) {
                    ChestRegistry.getInstance().register(coords.toShortString(), new ChestInfo(Rarity.SCARCE, (ICoords)coords));
                }
            }
            if ((savedData = GenDataPersistence.get(world)) != null) {
                savedData.func_76185_a();
            }
        }
    }

    public GeneratorResult<GeneratorData> generate(World world, Random random, ICoords coords, IWitherTreeConfig config) {
        GeneratorResult<GeneratorData> result = new GeneratorResult<GeneratorData>(GeneratorData.class);
        ICoords surfaceCoords = null;
        ICoords witherTreeCoords = null;
        surfaceCoords = WorldInfo.getDryLandSurfaceCoords((World)world, (ICoords)coords);
        Treasure.logger.debug("Surface Coords @ {}", (Object)surfaceCoords.toShortString());
        if (surfaceCoords == null || surfaceCoords == WorldInfo.EMPTY_COORDS) {
            Treasure.logger.debug("Returning due to surface coords == null or EMPTY_COORDS");
            return result.fail();
        }
        witherTreeCoords = surfaceCoords;
        AxisAlignedBB witherGroveSize = new AxisAlignedBB(surfaceCoords.toPos());
        Treasure.logger.debug("generate pit");
        GeneratorResult<ChestGeneratorData> genResult = SurfaceChestWorldGenerator.generatePit(world, random, Rarity.SCARCE, witherTreeCoords, TreasureConfig.CHESTS.surfaceChests.scarceChestProperties);
        Treasure.logger.debug("result -> {}", (Object)genResult.toString());
        if (!genResult.isSuccess()) {
            return result.fail();
        }
        this.buildClearing(world, random, surfaceCoords);
        this.buildMainTree(world, random, surfaceCoords, config);
        witherGroveSize = witherGroveSize.func_72321_a(7.0, 0.0, 7.0);
        int numTrees = RandomHelper.randomInt((int)config.getMinSupportingTrees(), (int)config.getMaxSupportingTrees());
        for (int treeIndex = 0; treeIndex < numTrees; ++treeIndex) {
            double xlen = RandomHelper.randomDouble((double)5.0, (double)10.0);
            double zlen = RandomHelper.randomDouble((double)5.0, (double)10.0);
            int degrees = RandomHelper.randomInt((int)0, (int)360);
            ICoords c = witherTreeCoords.rotate(xlen, zlen, (double)degrees);
            if ((c = WorldInfo.getDryLandSurfaceCoords((World)world, (ICoords)c.withY(WorldInfo.getHeightValue((World)world, (ICoords)c)))) == null || c == WorldInfo.EMPTY_COORDS || !(c.getDistanceSq(witherTreeCoords) > 4.0) || world.func_180495_p(c.toPos()).func_177230_c() == TreasureBlocks.WITHER_LOG) continue;
            this.buildClearing(world, random, c);
            this.buildTree(world, random, c, config);
            AxisAlignedBB witherTreeClearingSize = new AxisAlignedBB(c.toPos()).func_72321_a(7.0, 0.0, 7.0);
            witherGroveSize = witherGroveSize.func_111270_a(witherTreeClearingSize);
        }
        Treasure.logger.debug("size of clearing -> {}", (Object)witherGroveSize.toString());
        this.buildRocks(world, random, witherGroveSize);
        this.buildScrub(world, random, witherGroveSize);
        ICoords chestCoords = genResult.getData().getChestContext().getCoords();
        if (chestCoords == null) {
            return result.fail();
        }
        WitherChestGenerator chestGen = new WitherChestGenerator();
        GeneratorResult<ChestGeneratorData> chestResult = chestGen.generate(world, random, chestCoords, Rarity.SCARCE, null);
        if (!chestResult.isSuccess()) {
            return result.fail();
        }
        Treasure.logger.info("CHEATER! wither chest at coords: {}", (Object)witherTreeCoords.toShortString());
        result.setData(chestResult.getData());
        return result.success();
    }

    private void buildScrub(World world, Random random, AxisAlignedBB witherGroveSize) {
        int width = Math.abs((int)(witherGroveSize.field_72336_d - witherGroveSize.field_72340_a));
        int depth = Math.abs((int)(witherGroveSize.field_72334_f - witherGroveSize.field_72339_c));
        Coords centerCoords = new Coords((int)(witherGroveSize.field_72340_a + (double)width * 0.5), (int)witherGroveSize.field_72338_b, (int)(witherGroveSize.field_72339_c + (double)depth * 0.5));
        for (int scrubIndex = 0; scrubIndex < RandomHelper.randomInt((int)5, (int)20); ++scrubIndex) {
            int zOffset;
            int xOffset = (int)(random.nextFloat() * (float)width - (float)(width / 2));
            ICoords surfaceCoords = WorldInfo.getDryLandSurfaceCoords((World)world, (ICoords)centerCoords.add(xOffset, 0, zOffset = (int)(random.nextFloat() * (float)depth - (float)(depth / 2))).withY(255));
            Block supportBlock = world.func_180495_p(surfaceCoords.down(1).toPos()).func_177230_c();
            if (supportBlock != Blocks.field_150346_d && supportBlock != Blocks.field_150354_m) continue;
            if (RandomHelper.checkProbability((Random)random, (int)25)) {
                world.func_175656_a(surfaceCoords.toPos(), Blocks.field_150364_r.func_176223_P());
                continue;
            }
            world.func_175656_a(surfaceCoords.toPos(), Blocks.field_150330_I.func_176223_P());
        }
    }

    private void buildRocks(World world, Random random, AxisAlignedBB witherGroveSize) {
        int width = Math.abs((int)(witherGroveSize.field_72336_d - witherGroveSize.field_72340_a));
        int depth = Math.abs((int)(witherGroveSize.field_72334_f - witherGroveSize.field_72339_c));
        Coords centerCoords = new Coords((int)(witherGroveSize.field_72340_a + (double)width * 0.5), (int)witherGroveSize.field_72338_b, (int)(witherGroveSize.field_72339_c + (double)depth * 0.5));
        for (int rockIndex = 0; rockIndex < RandomHelper.randomInt((int)0, (int)5); ++rockIndex) {
            int xOffset = (int)(random.nextFloat() * (float)width - (float)(width / 2));
            int zOffset = (int)(random.nextFloat() * (float)depth - (float)(depth / 2));
            ICoords rocksCoords = WorldInfo.getDryLandSurfaceCoords((World)world, (ICoords)centerCoords.add(xOffset, 0, zOffset).withY(255));
            if (world.func_180495_p((rocksCoords = rocksCoords.down(1)).toPos()).func_177230_c() instanceof ITreasureBlock) continue;
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    for (int x = 0; x < 2; ++x) {
                        if (!RandomHelper.checkProbability((Random)random, (int)70)) continue;
                        ICoords spawnCoords = new Coords(rocksCoords).add(x, y, z);
                        world.func_175656_a(spawnCoords.toPos(), Blocks.field_150341_Y.func_176223_P());
                    }
                }
            }
        }
    }

    private void buildClearing(World world, Random random, ICoords coords) {
        ICoords buildCoords = null;
        for (int xOffset = -7; xOffset <= 7; ++xOffset) {
            for (int zOffset = -7; zOffset <= 7; ++zOffset) {
                Cube cube;
                if (Math.abs(xOffset) + Math.abs(zOffset) > 7) continue;
                int yHeight = WorldInfo.getHeightValue((World)world, (ICoords)coords.add(xOffset, 255, zOffset));
                buildCoords = WorldInfo.getDryLandSurfaceCoords((World)world, (ICoords)new Coords(coords.getX() + xOffset, yHeight, coords.getZ() + zOffset));
                if (Math.abs(buildCoords.getY() - coords.getY()) < 3) {
                    cube = new Cube(world, buildCoords.down(1));
                    if (cube.isLiquid()) continue;
                    if (RandomHelper.checkProbability((Random)random, (int)90)) {
                        if (Math.abs(xOffset) < 4 && Math.abs(zOffset) < 4 && (Math.abs(xOffset) != 3 || Math.abs(zOffset) != 3)) {
                            world.func_175656_a(buildCoords.add(0, -1, 0).toPos(), Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL));
                        } else {
                            world.func_175656_a(buildCoords.add(0, -1, 0).toPos(), Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        }
                    }
                }
                cube = new Cube(world, buildCoords);
                Coords climbCoords = new Coords(buildCoords);
                while (cube.equalsBlock(Blocks.field_150364_r) || cube.equalsBlock(Blocks.field_150363_s)) {
                    world.func_175698_g(climbCoords.toPos());
                    climbCoords = climbCoords.add(0, 1, 0);
                    cube = new Cube(world, (ICoords)climbCoords);
                }
            }
        }
    }

    public void buildTree(World world, Random random, ICoords coords, IWitherTreeConfig config) {
        int maxSize = RandomHelper.randomInt((Random)random, (int)7, (int)config.getMaxTrunkSize());
        boolean hasLifeBeenAdded = false;
        for (int y = 0; y < maxSize; ++y) {
            if (y == 0 && !hasLifeBeenAdded) {
                world.func_175656_a(coords.add(0, y, 0).toPos(), TreasureBlocks.WITHER_LOG_SOUL.func_176223_P());
                hasLifeBeenAdded = true;
                continue;
            }
            world.func_175656_a(coords.add(0, y, 0).toPos(), TreasureBlocks.WITHER_LOG.func_176223_P());
            if (y == 0) {
                this.addRoot(world, random, coords, supportTrunkMatrix);
                continue;
            }
            if (y == maxSize - 1) {
                this.addTop(world, random, coords, y + 1, supportTrunkMatrix.get(random.nextInt(supportTrunkMatrix.size())));
                continue;
            }
            if (y <= 3) continue;
            this.addBranch(world, random, coords, y, maxSize, supportTrunkMatrix);
        }
    }

    public void buildMainTree(World world, Random random, ICoords coords, IWitherTreeConfig config) {
        Coords[] trunkCoords = new Coords[]{coords, coords.add(1, 0, 0), coords.add(0, 0, 1), coords.add(1, 0, 1)};
        int maxSize = RandomHelper.randomInt((Random)random, (int)9, (int)config.getMaxTrunkSize());
        boolean hasLifeBeenAdded = false;
        for (int trunkIndex = 0; trunkIndex < trunkCoords.length; ++trunkIndex) {
            for (int y = 0; y < maxSize; ++y) {
                if (trunkIndex == 2 && y == 2 && !hasLifeBeenAdded) {
                    world.func_175656_a(trunkCoords[trunkIndex].add(0, y, 0).toPos(), TreasureBlocks.WITHER_LOG_SOUL.func_176223_P().func_177226_a(WitherLogSoulBlock.APPEARANCE, (Comparable)((Object)WitherLogSoulBlock.Appearance.FACE)).func_177226_a((IProperty)WitherLogSoulBlock.FACING, (Comparable)EnumFacing.SOUTH));
                    hasLifeBeenAdded = true;
                    continue;
                }
                world.func_175656_a(trunkCoords[trunkIndex].add(0, y, 0).toPos(), TreasureBlocks.WITHER_LOG.func_176223_P());
                if (y == 0) {
                    this.addRoot(world, random, (ICoords)trunkCoords[trunkIndex], trunkMatrix[trunkIndex]);
                    continue;
                }
                if (y == maxSize - 1) {
                    this.addTop(world, random, (ICoords)trunkCoords[trunkIndex], y + 1, topMatrix.get(trunkIndex));
                    continue;
                }
                if (y < 3) continue;
                this.addBranch(world, random, (ICoords)trunkCoords[trunkIndex], y, maxSize, trunkMatrix[trunkIndex]);
            }
            if (maxSize <= 3) continue;
            maxSize -= RandomHelper.randomInt((Random)random, (int)1, (int)3);
            maxSize = Math.max(3, maxSize);
        }
    }

    private void addTop(World world, Random random, ICoords coords, int y, Direction direction) {
        if (direction != null) {
            IBlockState state = TreasureBlocks.WITHER_BROKEN_LOG.func_176223_P().func_177226_a((IProperty)WitherRootBlock.FACING, (Comparable)direction.toFacing());
            world.func_175656_a(coords.add(0, y, 0).toPos(), state);
        }
    }

    private void addRoot(World world, Random random, ICoords coords, List<Direction> directions) {
        for (Direction d : directions) {
            if (!RandomHelper.checkProbability((Random)random, (int)50)) continue;
            ICoords c = coords.add(d, 1);
            Cube groundCube = new Cube(world, c.down(1));
            Cube replaceCube = new Cube(world, c);
            if (!groundCube.isSolid() || !groundCube.isTopSolid() || !replaceCube.isAir() && !replaceCube.isReplaceable()) continue;
            IBlockState state = TreasureBlocks.WITHER_ROOT.func_176223_P().func_177226_a((IProperty)WitherRootBlock.FACING, (Comparable)d.toFacing()).func_177226_a((IProperty)WitherRootBlock.ACTIVATED, (Comparable)Boolean.valueOf(true));
            world.func_175656_a(c.toPos(), state);
        }
    }

    private void addBranch(World world, Random random, ICoords trunkCoords, int y, int maxSize, List<Direction> directions) {
        int branchSize = 0;
        branchSize = y < maxSize / 3 || y > maxSize / 4 ? 2 : 1;
        block0: for (Direction d : directions) {
            if (!RandomHelper.checkProbability((Random)random, (int)30)) continue;
            ICoords c = trunkCoords;
            for (int segment = 0; segment < branchSize; ++segment) {
                c = c.add(d, 1);
                Cube replaceCube = new Cube(world, c);
                if (world.func_180495_p(c.down(1).toPos()).func_177230_c() instanceof WitherBranchBlock || !replaceCube.isAir() && !replaceCube.isReplaceable()) continue block0;
                IBlockState state = TreasureBlocks.WITHER_BRANCH.func_176223_P().func_177226_a((IProperty)WitherBranchBlock.FACING, (Comparable)d.toFacing());
                world.func_175656_a(c.add(0, y, 0).toPos(), state);
                if (!RandomHelper.checkProbability((Random)random, (int)80) || !(replaceCube = new Cube(world, c.add(0, y - 1, 0))).isAir() && !replaceCube.isReplaceable()) continue;
                world.func_175656_a(c.add(0, y - 1, 0).toPos(), TreasureBlocks.SPANISH_MOSS.func_176223_P().func_177226_a((IProperty)SpanishMossBlock.ACTIVATED, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    private void generateNether(World world, Random random, int i, int j) {
    }

    private void generateEnd(World world, Random random, int i, int j) {
    }

    public boolean isRegisteredChestWithinDistance(World world, ICoords coords, int minDistance) {
        double minDistanceSq = minDistance * minDistance;
        List<ChestInfo> infos = ChestRegistry.getInstance().getValues();
        if (infos == null || infos.size() == 0) {
            Treasure.logger.debug("Unable to locate the ChestConfig Registry or the Registry doesn't contain any values");
            return false;
        }
        for (ChestInfo info : infos) {
            double distance = coords.getDistanceSq(info.getCoords());
            if (!(distance < minDistanceSq)) continue;
            return true;
        }
        return false;
    }

    public int getChunksSinceLastTree() {
        return this.chunksSinceLastTree;
    }

    public void setChunksSinceLastTree(int chunksSinceLastTree) {
        this.chunksSinceLastTree = chunksSinceLastTree;
    }

    static {
        WitherTreeWorldGenerator.trunkMatrix[0] = new ArrayList<Direction>();
        WitherTreeWorldGenerator.trunkMatrix[1] = new ArrayList<Direction>();
        WitherTreeWorldGenerator.trunkMatrix[2] = new ArrayList<Direction>();
        WitherTreeWorldGenerator.trunkMatrix[3] = new ArrayList<Direction>();
        trunkMatrix[0].add(Direction.NORTH);
        trunkMatrix[0].add(Direction.WEST);
        trunkMatrix[1].add(Direction.NORTH);
        trunkMatrix[1].add(Direction.EAST);
        trunkMatrix[2].add(Direction.SOUTH);
        trunkMatrix[2].add(Direction.WEST);
        trunkMatrix[3].add(Direction.SOUTH);
        trunkMatrix[3].add(Direction.EAST);
        supportTrunkMatrix.add(Direction.NORTH);
        supportTrunkMatrix.add(Direction.EAST);
        supportTrunkMatrix.add(Direction.SOUTH);
        supportTrunkMatrix.add(Direction.WEST);
        topMatrix.add(Direction.EAST);
        topMatrix.add(Direction.SOUTH);
        topMatrix.add(null);
        topMatrix.add(null);
    }
}

