/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.citadel;

import greymerk.roguelike.citadel.Citadel;
import greymerk.roguelike.dungeon.towers.ITower;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.util.graph.Edge;
import greymerk.roguelike.util.graph.Graph;
import greymerk.roguelike.util.mst.MSTPoint;
import greymerk.roguelike.util.mst.MinimumSpanningTree;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.List;
import java.util.Random;

public class CityGrounds {
    public static void generate(IWorldEditor editor, Random rand, MinimumSpanningTree mst, ITheme theme, Coord pos) {
        Coord start = new Coord(pos);
        start.translate(new Coord(-51, 10, -51));
        Coord end = new Coord(pos);
        end.translate(new Coord(51, 40, 51));
        RectSolid.fill(editor, rand, start, end, BlockType.get(BlockType.AIR), true, true);
        start = new Coord(pos);
        start.translate(new Coord(-51, 10, -51));
        end = new Coord(pos);
        end.translate(new Coord(51, 20, 51));
        RectSolid.fill(editor, rand, start, end, theme.getPrimary().getWall(), true, true);
        start = new Coord(pos);
        start.translate(new Coord(-34, 20, -34));
        end = new Coord(pos);
        end.translate(new Coord(34, 30, 34));
        RectSolid.fill(editor, rand, start, end, theme.getPrimary().getWall(), true, true);
        start = new Coord(pos);
        start.translate(new Coord(-17, 30, -17));
        end = new Coord(pos);
        end.translate(new Coord(17, 40, 17));
        RectSolid.fill(editor, rand, start, end, theme.getPrimary().getWall(), true, true);
        Coord cursor = new Coord(pos);
        cursor.translate(Cardinal.UP, 20);
        for (Edge<MSTPoint> e : mst.getEdges()) {
            start = e.getStart().getPosition();
            start.translate(cursor);
            end = e.getEnd().getPosition();
            end.translate(cursor);
            end.translate(Cardinal.DOWN, 20);
            RectSolid.fill(editor, rand, start, end, theme.getPrimary().getWall(), true, true);
        }
        Graph<Coord> layout = mst.getGraph();
        List<Coord> towers = layout.getPoints();
        for (Coord c : towers) {
            c.translate(pos);
            rand = Citadel.getRandom(editor, c.getX(), c.getZ());
            ITower tower = Tower.get(Tower.values()[rand.nextInt(Tower.values().length)]);
            tower.generate(editor, rand, Theme.values()[rand.nextInt(Theme.values().length)].getThemeBase(), new Coord(c.getX(), 50, c.getZ()));
        }
    }
}

