/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.dungeon.DungeonNode;
import greymerk.roguelike.dungeon.ILevelGenerator;
import greymerk.roguelike.dungeon.LevelLayout;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBounded;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.filter.Filter;
import greymerk.roguelike.worldgen.filter.IFilter;
import java.util.Random;

public class DungeonLevel {
    private LevelSettings settings;
    private ILevelGenerator generator;

    public DungeonLevel(LevelSettings settings) {
        this.settings = settings;
    }

    public void generate(ILevelGenerator generator, Coord start) {
        this.generator = generator;
        generator.generate(start);
    }

    public int nodeCount() {
        return this.generator.getLayout().getNodes().size();
    }

    public LevelSettings getSettings() {
        return this.settings;
    }

    public boolean hasNearbyNode(Coord pos) {
        return this.generator.getLayout().getNodes().stream().anyMatch(node -> this.isNearby(pos, (DungeonNode)node));
    }

    private boolean isNearby(Coord pos, DungeonNode node) {
        return (int)node.getPosition().distance(pos) < node.getSize();
    }

    public LevelLayout getLayout() {
        return this.generator.getLayout();
    }

    public void encase(IWorldEditor editor, Random rand) {
        this.encaseNodes(editor, rand);
        this.encaseTunnels(editor, rand);
    }

    private void encaseNodes(IWorldEditor editor, Random rand) {
        DungeonNode start = this.generator.getLayout().getStart();
        DungeonNode end = this.generator.getLayout().getEnd();
        this.generator.getLayout().getNodes().stream().filter(node -> node != start && node != end).forEach(node -> node.encase(editor, rand, this.settings.getTheme()));
    }

    private void encaseTunnels(IWorldEditor editor, Random rand) {
        this.generator.getLayout().getTunnels().forEach(t -> t.encase(editor, rand, this.settings.getTheme()));
    }

    public void applyFilters(IWorldEditor editor, Random rand) {
        this.settings.getFilters().stream().map(Filter::get).forEach(filter -> this.filter(editor, rand, (IFilter)filter));
    }

    public void filter(IWorldEditor editor, Random rand, IFilter filter) {
        this.generator.getLayout().getBoundingBoxes().forEach(box -> filter.apply(editor, rand, this.settings.getTheme(), (IBounded)box));
    }
}

