/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.base;

import com.google.common.collect.Lists;
import greymerk.roguelike.dungeon.base.RoomType;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;

public class RoomsSetting {
    private List<RoomSetting> singleRoomSettings = new LinkedList<RoomSetting>();
    private WeightedRandomizer<RoomSetting> randomRooms = new WeightedRandomizer();

    public RoomsSetting() {
    }

    public RoomsSetting(RoomsSetting toCopy) {
        this.singleRoomSettings = Lists.newLinkedList(toCopy.singleRoomSettings);
        this.randomRooms = new WeightedRandomizer<RoomSetting>(toCopy.randomRooms);
    }

    public RoomsSetting(RoomsSetting parent, RoomsSetting child) {
        this.singleRoomSettings = Lists.newLinkedList((child.singleRoomSettings.isEmpty() ? parent : child).singleRoomSettings);
        this.randomRooms = new WeightedRandomizer<RoomSetting>((child.randomRooms.isEmpty() ? parent : child).randomRooms);
    }

    public static RoomsSetting getRandom(Random random, int numRooms) {
        RoomsSetting rooms = new RoomsSetting();
        IntStream.range(0, numRooms).forEach(i -> rooms.add(RoomType.getRandomIntersection(random).newRandomRoomSetting(1)));
        return rooms;
    }

    public void add(RoomSetting roomSetting) {
        if (roomSetting.isSingle()) {
            this.addSingleRoom(roomSetting);
        }
        if (roomSetting.isRandom()) {
            this.addRandomRoom(roomSetting);
        }
    }

    private void addSingleRoom(RoomSetting roomSetting) {
        IntStream.range(0, roomSetting.getCount()).mapToObj(operand -> roomSetting).forEach(this.singleRoomSettings::add);
    }

    private void addRandomRoom(RoomSetting roomSetting) {
        this.randomRooms.add(new WeightedChoice<RoomSetting>(roomSetting, roomSetting.getWeight()));
    }

    public String toString() {
        return "RoomsSetting(singleRoomSettings=" + this.getSingleRoomSettings() + ", randomRooms=" + this.getRandomRooms() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoomsSetting)) {
            return false;
        }
        RoomsSetting other = (RoomsSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<RoomSetting> this$singleRoomSettings = this.getSingleRoomSettings();
        List<RoomSetting> other$singleRoomSettings = other.getSingleRoomSettings();
        if (this$singleRoomSettings == null ? other$singleRoomSettings != null : !((Object)this$singleRoomSettings).equals(other$singleRoomSettings)) {
            return false;
        }
        WeightedRandomizer<RoomSetting> this$randomRooms = this.getRandomRooms();
        WeightedRandomizer<RoomSetting> other$randomRooms = other.getRandomRooms();
        return !(this$randomRooms == null ? other$randomRooms != null : !((Object)this$randomRooms).equals(other$randomRooms));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoomsSetting;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RoomSetting> $singleRoomSettings = this.getSingleRoomSettings();
        result = result * 59 + ($singleRoomSettings == null ? 43 : ((Object)$singleRoomSettings).hashCode());
        WeightedRandomizer<RoomSetting> $randomRooms = this.getRandomRooms();
        result = result * 59 + ($randomRooms == null ? 43 : ((Object)$randomRooms).hashCode());
        return result;
    }

    public List<RoomSetting> getSingleRoomSettings() {
        return this.singleRoomSettings;
    }

    public WeightedRandomizer<RoomSetting> getRandomRooms() {
        return this.randomRooms;
    }
}

