/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.base;

import com.google.common.collect.Lists;
import greymerk.roguelike.dungeon.base.RoomType;
import greymerk.roguelike.dungeon.base.SecretRoom;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;

public class SecretsSetting {
    private List<SecretRoom> secretRooms = Lists.newArrayList();

    public SecretsSetting() {
    }

    public SecretsSetting(SecretsSetting toCopy) {
        this.getSecretRooms().addAll(toCopy.getSecretRooms());
    }

    public SecretsSetting(SecretsSetting base, SecretsSetting other) {
        if (base != null) {
            this.getSecretRooms().addAll(base.getSecretRooms());
        }
        if (other != null) {
            this.getSecretRooms().addAll(other.getSecretRooms());
        }
    }

    public static SecretsSetting getRandom(Random rand, int count) {
        SecretsSetting secrets = new SecretsSetting();
        IntStream.range(0, count).mapToObj(i -> RoomType.getRandomSecret(rand)).forEach(type -> secrets.add(type.newSingleRoomSetting()));
        return secrets;
    }

    public void add(RoomSetting roomSetting) {
        IntStream.range(0, roomSetting.getCount()).forEach(value -> this.getSecretRooms().add(new SecretRoom(roomSetting)));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretsSetting)) {
            return false;
        }
        SecretsSetting other = (SecretsSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<SecretRoom> this$secretRooms = this.getSecretRooms();
        List<SecretRoom> other$secretRooms = other.getSecretRooms();
        return !(this$secretRooms == null ? other$secretRooms != null : !((Object)this$secretRooms).equals(other$secretRooms));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecretsSetting;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SecretRoom> $secretRooms = this.getSecretRooms();
        result = result * 59 + ($secretRooms == null ? 43 : ((Object)$secretRooms).hashCode());
        return result;
    }

    public List<SecretRoom> getSecretRooms() {
        return this.secretRooms;
    }

    public String toString() {
        return "SecretsSetting(secretRooms=" + this.getSecretRooms() + ")";
    }
}

