/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.base.SecretsSetting;
import greymerk.roguelike.dungeon.segment.alcove.PrisonCell;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Optional;
import java.util.Random;

public class SegmentPrisonCell
extends SegmentBase {
    @Override
    protected void genWall(IWorldEditor editor, Random rand, DungeonLevel level, Cardinal dir, ITheme theme, Coord origin) {
        MetaBlock air = BlockType.get(BlockType.AIR);
        IStair stair = theme.getSecondary().getStair();
        Coord cursor = new Coord(origin);
        Cardinal[] orth = dir.orthogonal();
        cursor.translate(dir, 2);
        Coord start = new Coord(cursor);
        start.translate(orth[0], 1);
        Coord end = new Coord(cursor);
        end.translate(orth[1], 1);
        end.translate(Cardinal.UP, 2);
        RectSolid.fill(editor, rand, start, end, air);
        SecretsSetting secrets = level.getSettings().getSecrets();
        Optional<DungeonBase> room = this.generateSecret(secrets, editor, rand, level.getSettings(), dir, new Coord(origin));
        start.translate(dir, 1);
        end.translate(dir, 1);
        RectSolid.fill(editor, rand, start, end, theme.getSecondary().getWall(), false, true);
        cursor.translate(Cardinal.UP, 2);
        for (Cardinal d : orth) {
            Coord c = new Coord(cursor);
            c.translate(d, 1);
            stair.setOrientation(d.reverse(), true);
            stair.set(editor, c);
        }
        if (room.isPresent()) {
            cursor = new Coord(origin);
            cursor.translate(dir, 3);
            theme.getSecondary().getDoor().generate(editor, cursor, dir.reverse());
        } else {
            PrisonCell cell = new PrisonCell();
            if (cell.isValidLocation(editor, new Coord(origin), dir)) {
                cell.generate(editor, rand, level.getSettings(), new Coord(origin), dir);
            }
        }
    }
}

