/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.google.common.collect.Sets;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.SettingsType;
import greymerk.roguelike.dungeon.settings.SpawnCriteria;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.treasure.TreasureManager;
import greymerk.roguelike.treasure.loot.LootRuleManager;
import greymerk.roguelike.treasure.loot.LootTableRule;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IPositionInfo;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;

public class DungeonSettings {
    private static final int MAX_NUM_LEVELS = 5;
    private SettingIdentifier id;
    private List<SettingIdentifier> inherit = new ArrayList<SettingIdentifier>();
    private boolean exclusive;
    private TowerSettings towerSettings;
    private Map<Integer, LevelSettings> levels = new HashMap<Integer, LevelSettings>();
    private SpawnCriteria spawnCriteria = new SpawnCriteria();
    private LootRuleManager lootRules = new LootRuleManager();
    private List<LootTableRule> lootTables = new ArrayList<LootTableRule>();
    private Set<SettingsType> overrides = new HashSet<SettingsType>();

    public DungeonSettings() {
    }

    public DungeonSettings(String id) {
        this(new SettingIdentifier(id));
    }

    public DungeonSettings(SettingIdentifier id) {
        this.setId(id);
    }

    public DungeonSettings(DungeonSettings parent, DungeonSettings child) {
        this.getOverrides().addAll((Collection<SettingsType>)Optional.ofNullable(child.getOverrides()).orElse(Sets.newHashSet()));
        this.setLootRules(new LootRuleManager());
        if (!this.getOverrides().contains((Object)SettingsType.LOOTRULES)) {
            this.getLootRules().add(parent.getLootRules());
            this.getLootTables().addAll(parent.getLootTables());
        }
        this.getLootRules().add(child.getLootRules());
        this.getLootTables().addAll(child.getLootTables());
        this.getInherit().addAll(child.getInherit());
        this.setExclusive(child.isExclusive());
        this.setTowerSettings(this.getTowerSettings(parent, child));
        IntStream.range(0, DungeonSettings.getMaxNumLevels()).forEach(i -> this.getLevels().put(i, this.newLevelSettings(parent, child, i)));
    }

    private LevelSettings newLevelSettings(DungeonSettings parent, DungeonSettings child, int i) {
        return new LevelSettings(parent.getLevels().get(i), child.getLevels().get(i), this.getOverrides());
    }

    private TowerSettings getTowerSettings(DungeonSettings parent, DungeonSettings child) {
        if (this.getOverrides().contains((Object)SettingsType.TOWER) && child.getTowerSettings() != null) {
            return new TowerSettings(child.getTowerSettings());
        }
        if (parent.getTowerSettings() != null || child.getTowerSettings() != null) {
            return new TowerSettings(parent.getTowerSettings(), child.getTowerSettings());
        }
        return null;
    }

    public DungeonSettings(DungeonSettings toCopy) {
        this.setTowerSettings(toCopy.getTowerSettings() != null ? new TowerSettings(toCopy.getTowerSettings()) : null);
        this.setLootRules(toCopy.getLootRules());
        this.getLootTables().addAll(toCopy.getLootTables());
        this.getInherit().addAll(toCopy.getInherit());
        this.setExclusive(toCopy.isExclusive());
        for (int i = 0; i < DungeonSettings.getMaxNumLevels(); ++i) {
            LevelSettings level = toCopy.getLevels().get(i);
            if (level == null) {
                this.getLevels().put(i, new LevelSettings());
                continue;
            }
            this.getLevels().put(i, new LevelSettings(level));
        }
        if (toCopy.getOverrides() != null) {
            this.getOverrides().addAll(toCopy.getOverrides());
        }
    }

    public static int getMaxNumLevels() {
        return 5;
    }

    public SettingIdentifier getId() {
        return this.id;
    }

    public void setId(SettingIdentifier id) {
        this.id = id;
    }

    public List<SettingIdentifier> getInherits() {
        return this.getInherit() != null ? this.getInherit() : new ArrayList<SettingIdentifier>();
    }

    public String getNamespace() {
        return Optional.ofNullable(this.getId().getNamespace()).orElse("default");
    }

    public String getName() {
        return this.getId().getName();
    }

    public void setSpawnCriteria(SpawnCriteria spawnCriteria) {
        this.spawnCriteria = spawnCriteria;
    }

    public boolean isValid(IWorldEditor editor, Coord pos) {
        IPositionInfo positionInfo = editor.getInfo(pos);
        return this.getSpawnCriteria().isValid(positionInfo);
    }

    public LevelSettings getLevelSettings(int level) {
        return this.getLevels().get(level);
    }

    public TowerSettings getTower() {
        if (this.getTowerSettings() == null) {
            return new TowerSettings(Tower.ROGUE, Theme.STONE);
        }
        return this.getTowerSettings();
    }

    public int getNumLevels() {
        return DungeonSettings.getMaxNumLevels();
    }

    public Set<SettingsType> getOverrides() {
        return this.overrides;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void processLoot(Random rand, TreasureManager treasure) {
        this.getLootRules().process(rand, treasure);
        this.getLootTables().forEach(table -> table.process(treasure));
    }

    public LootRuleManager getLootRules() {
        return this.lootRules;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public TowerSettings getTowerSettings() {
        return this.towerSettings;
    }

    public void setTowerSettings(TowerSettings towerSettings) {
        this.towerSettings = towerSettings;
    }

    public List<SettingIdentifier> getInherit() {
        return this.inherit;
    }

    public void setInherit(List<SettingIdentifier> inherit) {
        this.inherit = inherit;
    }

    public Map<Integer, LevelSettings> getLevels() {
        return this.levels;
    }

    public void setLevels(Map<Integer, LevelSettings> levels) {
        this.levels = levels;
    }

    public SpawnCriteria getSpawnCriteria() {
        return this.spawnCriteria;
    }

    public void setLootRules(LootRuleManager lootRules) {
        this.lootRules = lootRules;
    }

    public List<LootTableRule> getLootTables() {
        return this.lootTables;
    }
}

