/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.tasks;

import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.DungeonNode;
import greymerk.roguelike.dungeon.ILevelGenerator;
import greymerk.roguelike.dungeon.LevelGenerator;
import greymerk.roguelike.dungeon.LevelLayout;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.base.RoomIterator;
import greymerk.roguelike.dungeon.base.RoomType;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.tasks.IDungeonTask;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.List;
import java.util.Random;

public class DungeonTaskLayout
implements IDungeonTask {
    @Override
    public void execute(IWorldEditor editor, Random random, Dungeon dungeon, DungeonSettings settings) {
        List<DungeonLevel> levels = dungeon.getLevels();
        Coord start = dungeon.getPosition();
        for (DungeonLevel level : levels) {
            ILevelGenerator generator = LevelGenerator.getGenerator(editor, random, level.getSettings().getGenerator(), level);
            try {
                level.generate(generator, start);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LevelLayout layout = generator.getLayout();
            random = Dungeon.getRandom(editor, start);
            start = new Coord(layout.getEnd().getPosition());
            start.translate(Cardinal.DOWN, 10);
        }
        for (DungeonLevel level : levels) {
            LevelLayout layout = level.getLayout();
            RoomIterator roomIterator = new RoomIterator(level.getSettings().getRooms(), random);
            int count = 0;
            while (layout.hasEmptyRooms()) {
                DungeonBase toGenerate = count < level.getSettings().getNumRooms() ? roomIterator.getDungeonRoom() : RoomType.CORNER.newSingleRoomSetting().instantiate();
                DungeonNode node = layout.getBestFit(toGenerate);
                node.setDungeon(toGenerate);
                ++count;
            }
        }
    }
}

