/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.theme;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.theme.BlockSet;
import greymerk.roguelike.worldgen.BlockProvider;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.MetaStair;
import greymerk.roguelike.worldgen.blocks.door.Door;
import greymerk.roguelike.worldgen.blocks.door.IDoor;
import java.util.Optional;

class BlockSetParser {
    BlockSetParser() {
    }

    public static BlockSet parseBlockSet(JsonObject json, BlockSet baseBlockSet) throws Exception {
        return new BlockSet(BlockSetParser.parseFloor(json).orElse(baseBlockSet.getFloor()), BlockSetParser.parseWalls(json).orElse(baseBlockSet.getWall()), BlockSetParser.parseStair(json).orElse(baseBlockSet.getStair()), BlockSetParser.parsePillar(json).orElse(baseBlockSet.getPillar()), BlockSetParser.parseDoor(json).orElse(baseBlockSet.getDoor()), BlockSetParser.parseLightBlock(json).orElse(baseBlockSet.getLightBlock()), BlockSetParser.parseLiquid(json).orElse(baseBlockSet.getLiquid()));
    }

    private static Optional<IBlockFactory> parseFloor(JsonObject json) throws Exception {
        return json.has("floor") ? Optional.ofNullable(BlockProvider.create(json.get("floor").getAsJsonObject())) : Optional.empty();
    }

    private static Optional<IBlockFactory> parseWalls(JsonObject json) throws Exception {
        return json.has("walls") ? Optional.ofNullable(BlockProvider.create(json.get("walls").getAsJsonObject())) : Optional.empty();
    }

    private static Optional<IStair> parseStair(JsonObject json) throws Exception {
        return json.has("stair") ? Optional.of(BlockSetParser.somethingAboutStairWithData(json)) : Optional.empty();
    }

    private static MetaStair somethingAboutStairWithData(JsonObject json) throws Exception {
        JsonObject stairData = json.get("stair").getAsJsonObject();
        return stairData.has("data") ? new MetaStair(new MetaBlock((JsonElement)stairData.get("data").getAsJsonObject())) : new MetaStair(new MetaBlock((JsonElement)stairData));
    }

    private static Optional<IBlockFactory> parsePillar(JsonObject json) throws Exception {
        return json.has("pillar") ? Optional.ofNullable(BlockProvider.create(json.get("pillar").getAsJsonObject())) : Optional.empty();
    }

    private static Optional<IDoor> parseDoor(JsonObject json) throws Exception {
        return json.has("door") ? Optional.of(new Door(json.get("door"))) : Optional.empty();
    }

    private static Optional<IBlockFactory> parseLightBlock(JsonObject json) throws Exception {
        return json.has("lightblock") ? Optional.ofNullable(BlockProvider.create(json.get("lightblock").getAsJsonObject())) : Optional.empty();
    }

    private static Optional<IBlockFactory> parseLiquid(JsonObject json) throws Exception {
        return json.has("liquid") ? Optional.ofNullable(BlockProvider.create(json.get("liquid").getAsJsonObject())) : Optional.empty();
    }
}

