/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure;

import greymerk.roguelike.treasure.ChestPlacementException;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;

public enum Treasure {
    ARMOUR,
    WEAPONS,
    BLOCKS,
    ENCHANTING,
    FOOD,
    ORE,
    POTIONS,
    STARTER,
    TOOLS,
    SUPPLIES,
    SMITH,
    MUSIC,
    REWARD,
    EMPTY,
    BREWING;

    public static final Treasure[] COMMON_TREASURES;
    public static final Treasure[] RARE_TREASURES;
    public static final Treasure[] SUPPLIES_TREASURES;

    public static void createChests(IWorldEditor editor, Random random, int level, List<Coord> chestLocations, boolean isTrapped, Treasure ... types) {
        chestLocations.forEach(chestLocation -> Treasure.createChest(editor, random, level, chestLocation, isTrapped, types));
    }

    public static void createChest(IWorldEditor editor, Random random, int level, Coord chestLocation, boolean isTrapped, Treasure ... treasures) {
        if (Treasure.isValidChestSpace(editor, chestLocation)) {
            Treasure type = Treasure.chooseRandomType(random, treasures);
            Treasure.safeGenerate(editor, random, level, chestLocation, isTrapped, type);
        }
    }

    private static Treasure chooseRandomType(Random random, Treasure ... treasures) {
        return treasures[random.nextInt(treasures.length)];
    }

    private static void safeGenerate(IWorldEditor editor, Random random, int level, Coord chestLocation, boolean isTrapped, Treasure type) {
        try {
            TreasureChest chest = new TreasureChest(type);
            chest.generate(editor, random, chestLocation, level, isTrapped);
        }
        catch (ChestPlacementException chestPlacementException) {
            // empty catch block
        }
    }

    private static boolean isValidChestSpace(IWorldEditor editor, Coord coord) {
        return editor.isAirBlock(coord) && !Treasure.isNonSolidBlock(editor, coord) && Treasure.isNotNextToChest(editor, coord);
    }

    private static boolean isNotNextToChest(IWorldEditor editor, Coord coord) {
        return Arrays.stream(Cardinal.directions).noneMatch(dir -> Treasure.isBesideChest(editor, coord, dir));
    }

    private static boolean isBesideChest(IWorldEditor editor, Coord coord, Cardinal dir) {
        Coord otherCursor = coord.add(dir);
        return editor.getBlock(otherCursor).func_177230_c() == Blocks.field_150486_ae;
    }

    private static boolean isNonSolidBlock(IWorldEditor editor, Coord coord) {
        Coord cursor = coord.add(Cardinal.DOWN);
        return !editor.getBlock(cursor).func_185904_a().func_76220_a();
    }

    static {
        COMMON_TREASURES = new Treasure[]{ARMOUR, BLOCKS, EMPTY, FOOD, REWARD, SUPPLIES, TOOLS, WEAPONS};
        RARE_TREASURES = new Treasure[]{ARMOUR, ENCHANTING, POTIONS, ORE, REWARD, TOOLS, WEAPONS};
        SUPPLIES_TREASURES = new Treasure[]{BLOCKS, SUPPLIES};
    }
}

