/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot.provider;

import com.google.gson.JsonObject;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemBase;
import greymerk.roguelike.treasure.loot.provider.ItemSpecialty;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ItemTool
extends ItemBase {
    private Equipment type;
    private boolean enchant;
    private Quality quality;

    public ItemTool(int weight, int level) {
        super(weight, level);
    }

    public ItemTool(JsonObject data, int weight) throws Exception {
        super(weight);
        boolean bl = this.enchant = !data.has("ench") || data.get("ench").getAsBoolean();
        if (!data.has("level")) {
            throw new Exception("Tool Loot requires a level");
        }
        this.level = data.get("level").getAsInt();
        if (data.has("equipment")) {
            try {
                this.type = Equipment.valueOf(data.get("equipment").getAsString().toUpperCase());
            }
            catch (Exception e) {
                throw new Exception("No such Equipment as: " + data.get("equipment").getAsString());
            }
        }
        if (data.has("quality")) {
            try {
                this.quality = Quality.valueOf(data.get("quality").getAsString().toUpperCase());
            }
            catch (Exception e) {
                throw new Exception("No such Quality as: " + data.get("quality").getAsString());
            }
        }
    }

    public static ItemStack getTool(Random rand, int level, Quality quality, Equipment type, boolean enchant) {
        ItemStack tool = Equipment.get(type, quality == null ? Quality.get(level) : quality);
        return enchant ? Enchant.enchantItem(rand, tool, Enchant.getLevel(rand, level)) : tool;
    }

    public static ItemStack getRandom(Random rand, int level, boolean enchant) {
        if (enchant && rand.nextInt(20 + level * 10) == 0) {
            switch (rand.nextInt(3)) {
                case 0: {
                    return ItemSpecialty.getRandomItem(Equipment.PICK, rand, level);
                }
                case 1: {
                    return ItemSpecialty.getRandomItem(Equipment.AXE, rand, level);
                }
                case 2: {
                    return ItemSpecialty.getRandomItem(Equipment.SHOVEL, rand, level);
                }
            }
        }
        ItemStack tool = ItemTool.pickTool(rand, level);
        if (enchant && rand.nextInt(6 - level) == 0) {
            Enchant.enchantItem(rand, tool, Enchant.getLevel(rand, level));
        }
        return tool;
    }

    private static ItemStack pickTool(Random rand, int rank) {
        switch (rand.nextInt(3)) {
            case 0: {
                return ItemTool.pickPick(rand, rank);
            }
            case 1: {
                return ItemTool.pickAxe(rand, rank);
            }
            case 2: {
                return ItemTool.pickShovel(rand, rank);
            }
        }
        return ItemTool.pickPick(rand, rank);
    }

    private static ItemStack pickAxe(Random rand, int level) {
        Quality quality = Quality.getToolQuality(rand, level);
        switch (quality) {
            case DIAMOND: {
                return new ItemStack(Items.field_151056_x);
            }
            case GOLD: {
                return new ItemStack(Items.field_151006_E);
            }
            case IRON: {
                return new ItemStack(Items.field_151036_c);
            }
            case STONE: {
                return new ItemStack(Items.field_151049_t);
            }
        }
        return new ItemStack(Items.field_151053_p);
    }

    private static ItemStack pickShovel(Random rand, int level) {
        Quality quality = Quality.getToolQuality(rand, level);
        switch (quality) {
            case DIAMOND: {
                return new ItemStack(Items.field_151047_v);
            }
            case GOLD: {
                return new ItemStack(Items.field_151011_C);
            }
            case IRON: {
                return new ItemStack(Items.field_151037_a);
            }
            case STONE: {
                return new ItemStack(Items.field_151051_r);
            }
        }
        return new ItemStack(Items.field_151038_n);
    }

    private static ItemStack pickPick(Random rand, int level) {
        Quality quality = Quality.getToolQuality(rand, level);
        switch (quality) {
            case DIAMOND: {
                return new ItemStack(Items.field_151046_w);
            }
            case GOLD: {
                return new ItemStack(Items.field_151005_D);
            }
            case IRON: {
                return new ItemStack(Items.field_151035_b);
            }
            case STONE: {
                return new ItemStack(Items.field_151050_s);
            }
        }
        return new ItemStack(Items.field_151039_o);
    }

    @Override
    public ItemStack getLootItem(Random rand, int level) {
        if (this.type != null) {
            return ItemTool.getTool(rand, level, this.quality, this.type, this.enchant);
        }
        return ItemTool.getRandom(rand, level, true);
    }
}

